/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.automatons.security_framework.single_calculators;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertTrue;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

import jens.bothur.occt.automatons.security_framework.single_calculators.HighAndLowRatingSpamScoreCalculator;
import jens.bothur.occt.domainobjects.GroupOfRateableObjects;
import jens.bothur.occt.domainobjects.RateableObject;
import jens.bothur.occt.domainobjects.User;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link HighAndLowRatingSpamScoreCalculator}.
 * 
 * @author Jens Bothur
 */
public class HighAndLowRatingSpamScoreCalculatorTest {

	private final User _user1 = new User("a");
	private final User _user2 = new User("b");
	private final User _user3 = new User("c");
	private final User _user4 = new User("d");

	private Collection<User> _users;

	private final RateableObject _object1 = new RateableObject();
	private final RateableObject _object2 = new RateableObject();
	private final RateableObject _object3 = new RateableObject();
	private final RateableObject _object4 = new RateableObject();
	private final RateableObject _object5 = new RateableObject();

	private GroupOfRateableObjects _group1;
	private GroupOfRateableObjects _group2;

	private Set<GroupOfRateableObjects> _groups;

	/**
	 * @throws java.lang.Exception
	 */
	@SuppressWarnings({ "serial", "deprecation" })
	@Before
	public void setUp() throws Exception {
		_users = new LinkedHashSet<User>() {
			{
				add(_user1);
				add(_user2);
				add(_user3);
				add(_user4);
			}
		};
		_object1.rate(_user1, Review.FIVE_STAR_REVIEW, new Date(71, 20,
				1, 11, 11, 11));
		_object2.rate(_user1, Review.FIVE_STAR_REVIEW, new Date(71, 20,
				1, 11, 11, 12));
		_object3.rate(_user1, Review.FIVE_STAR_REVIEW, new Date(71, 20,
				1, 11, 11, 13));
		_object4.rate(_user1, Review.ONE_STAR_REVIEW, new Date(71, 20,
				1, 11, 11, 14));
		_object5.rate(_user1, Review.ONE_STAR_REVIEW, new Date(71, 20,
				1, 11, 11, 15));

		_object1.rate(_user2, Review.ONE_STAR_REVIEW, new Date(88, 1,
				1, 23, 59, 11));
		_object2.rate(_user2, Review.ONE_STAR_REVIEW, new Date(88, 1,
				1, 23, 59, 12));
		_object3.rate(_user2, Review.ONE_STAR_REVIEW, new Date(88, 1,
				1, 23, 59, 13));

		_object1.rate(_user3, Review.ONE_STAR_REVIEW, new Date(72, 20,
				1, 11, 11, 11));
		_object2.rate(_user3, Review.ONE_STAR_REVIEW, new Date(73, 20,
				1, 11, 11, 12));
		_object3.rate(_user3, Review.ONE_STAR_REVIEW, new Date(74, 20,
				1, 11, 11, 13));
		_object4.rate(_user3, Review.ONE_STAR_REVIEW, new Date(75, 20,
				1, 11, 11, 14));
		_object5.rate(_user3, Review.ONE_STAR_REVIEW, new Date(76, 20,
				1, 11, 11, 15));

		_group1 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object1);
						add(_object2);
						add(_object3);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user2);
						add(_user3);
					}
				});
		_group2 = new GroupOfRateableObjects(
				new LinkedHashSet<RateableObject>() {
					{
						add(_object4);
						add(_object5);
					}
				}, new LinkedHashSet<User>() {
					{
						add(_user1);
						add(_user3);
					}
				});

		_groups = new LinkedHashSet<GroupOfRateableObjects>() {
			{
				add(_group1);
				add(_group2);
			}
		};

	}

	@SuppressWarnings("deprecation")
	@Test
	public void testDatesAreWithinTimeWindow() {
		// diese private Methode wird per Reflection getestet
		try {
			Method datesAreWithinTimeWindow = HighAndLowRatingSpamScoreCalculator.class
					.getDeclaredMethod("datesAreWithinTimeWindow", Date.class,
							Date.class);
			datesAreWithinTimeWindow.setAccessible(true);

			assertTrue((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(), new Date()));
			assertTrue((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date(84, 30, 3, 17,
							22, 22)));
			assertTrue((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date(84, 30, 3, 18,
							12, 22)));
			assertTrue((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date(84, 30, 3, 18,
							22, 22)));
			assertFalse((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date(84, 30, 3, 18,
							22, 23)));
			assertFalse((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date(88, 30, 3, 17,
							22, 21)));
			assertFalse((Boolean) datesAreWithinTimeWindow.invoke(null,
					new Date(84, 30, 3, 17, 22, 22), new Date()));

		} catch (SecurityException e) {
			assertTrue(false);
		} catch (NoSuchMethodException e) {
			assertTrue(false);
		} catch (IllegalArgumentException e) {
			e.printStackTrace();
			assertTrue(false);
		} catch (IllegalAccessException e) {
			assertTrue(false);
		} catch (InvocationTargetException e) {
			e.printStackTrace();
			assertTrue(false);
		}

	}

	@Test
	public void testCalculateHighAndLowRatingScore() {
		Map<User, Double> result = HighAndLowRatingSpamScoreCalculator
				.calculateHighAndLowRatingScore(_users, _groups);
		// user 3 und 4 sollten beide einen score von 0 bekommen
		assertTrue(0 == result.get(_user3));
		assertTrue(0 == result.get(_user4));
		// user 2 sollte einen score von 0.5 bekommen, da er den hchsten low
		// score aber keinen high score hat.
		assertTrue(0.5 == result.get(_user2));
		// user 1 sollte einen score grer 0.5 bekommen, da er den hchsten
		// high score hat und einen low score
		// user 1 sollte einen score kleiner 1 haben, weil er nicht beide
		// hchsten scores hat.
		assertTrue(0.5 < result.get(_user1));
		assertTrue(1 > result.get(_user1));
	}

}
