/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainobjects;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Date;

import jens.bothur.occt.domainvalues.AverageReview;
import jens.bothur.occt.domainvalues.Review;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr die Klasse: {@link RateableObject}
 * 
 * @author Jens Bothur
 */
public class RateableObjectTest {

	private RateableObject _instance1;
	private RateableObject _instance2;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		_instance1 = new RateableObject();
		_instance2 = new RateableObject();
	}

	@Test
	public void testHashcodeAndEquals() {
		assertEquals(_instance1, _instance1);
		assertEquals(_instance2, _instance2);

		assertFalse(_instance1.equals(_instance2));
		assertFalse(_instance1.equals(null));
		assertFalse(_instance1.equals("Hallo"));

		assertTrue(_instance1.hashCode() == _instance1.hashCode());
		assertTrue(_instance2.hashCode() == _instance2.hashCode());
	}

	@Test
	public void testInitialState() {
		assertEquals(AverageReview.getAverageReviewByIntTimes10(30),
				_instance1.getAverageReview());
		assertTrue(3.0 == _instance1.getAverageReview().getValue());

		long id1 = _instance1.getID();
		long id2 = _instance2.getID();
		assertTrue(id1 == _instance1.getID());
		assertTrue(id2 == _instance2.getID());
		assertFalse(id1 == id2);

		assertTrue(_instance1.getReviewers().isEmpty());
		assertTrue(_instance2.getReviewers().isEmpty());

		for (int i = 0; i < 100; i++) {
			assertNull(_instance1.getReviewForReviewer(new User(i + "")));
			assertNull(_instance2.getReviewForReviewer(new User(i + "")));
		}
	}

	@Test
	public void testSetAverageReview() {
		AverageReview averageReview10 = AverageReview
				.getAverageReviewByDouble(1.0);
		AverageReview averageReview37 = AverageReview
				.getAverageReviewByDouble(3.7);
		AverageReview averageReview50 = AverageReview
				.getAverageReviewByDouble(5.0);

		_instance1.setAverageReview(averageReview10);
		assertEquals(averageReview10, _instance1.getAverageReview());
		assertTrue(10 == _instance1.getAverageReview().getValueTimes10());

		_instance1.setAverageReview(averageReview37);
		assertEquals(averageReview37, _instance1.getAverageReview());
		assertTrue(37 == _instance1.getAverageReview().getValueTimes10());

		_instance1.setAverageReview(averageReview50);
		assertEquals(averageReview50, _instance1.getAverageReview());
		assertTrue(50 == _instance1.getAverageReview().getValueTimes10());
	}

	@SuppressWarnings("deprecation")
	@Test
	public void testRate() {
		User userId1 = new User("as");
		User userId2 = new User("test");

		Review review1 = Review.FOUR_STAR_REVIEW;
		Review review2 = Review.ONE_STAR_REVIEW;
		Date date1 = new Date();
		Date date2 = new Date(1984, 3, 30);

		assertTrue(_instance1.rate(userId1, review1, date1));

		assertTrue(1 == _instance1.getReviewers().size());
		assertTrue(_instance1.getReviewers().contains(userId1));
		assertEquals(review1, _instance1.getReviewForReviewer(userId1));
		assertEquals(date1, _instance1.getDateForReviewer(userId1));

		assertFalse(_instance1.rate(userId1, review1, date2));

		assertTrue(1 == _instance1.getReviewers().size());
		assertTrue(_instance1.getReviewers().contains(userId1));
		assertEquals(review1, _instance1.getReviewForReviewer(userId1));
		assertEquals(date1, _instance1.getDateForReviewer(userId1));

		assertTrue(_instance1.rate(userId2, review2, date2));

		assertTrue(2 == _instance1.getReviewers().size());
		assertTrue(_instance1.getReviewers().contains(userId1));
		assertTrue(_instance1.getReviewers().contains(userId2));
		assertEquals(review1, _instance1.getReviewForReviewer(userId1));
		assertEquals(review2, _instance1.getReviewForReviewer(userId2));
		assertEquals(date1, _instance1.getDateForReviewer(userId1));
		assertEquals(date2, _instance1.getDateForReviewer(userId2));

		assertFalse(_instance1.rate(userId2, review2, date1));

		assertTrue(2 == _instance1.getReviewers().size());
		assertTrue(_instance1.getReviewers().contains(userId1));
		assertTrue(_instance1.getReviewers().contains(userId2));
		assertEquals(review1, _instance1.getReviewForReviewer(userId1));
		assertEquals(review2, _instance1.getReviewForReviewer(userId2));
		assertEquals(date1, _instance1.getDateForReviewer(userId1));
		assertEquals(date2, _instance1.getDateForReviewer(userId2));

		boolean exception = false;
		try {

			_instance1.rate(userId1, review1, new Date(-2000, 1, 1));
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		assertTrue("There should have been an IllegalArgumentException",
				exception);

		exception = false;
	}

}
