/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainobjects;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;
import jens.bothur.occt.domainvalues.ConfidenceLevel;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr Klasse: {@link User}.
 * 
 * @author Jens Bothur
 */
public class UserTest {

	private User _instance1;
	private User _instance2;
	private User _instance3;

	private final String NAME1 = "Derek Jeter";
	private final String NAME3 = "Mark Texeira";

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		_instance1 = new User(NAME1);
		_instance2 = new User(NAME1);
		_instance3 = new User(NAME3);
	}

	@Test
	public void testHashCodeAndEquals() {
		assertEquals(_instance1, _instance1);
		assertEquals(_instance2, _instance2);
		assertEquals(_instance3, _instance3);
		assertFalse(_instance1.equals(_instance2));
		assertFalse(_instance1.equals(_instance3));
		assertFalse(_instance2.equals(_instance3));
		assertFalse(_instance2.equals(null));
		assertFalse(_instance2.equals("Hallo"));

		assertTrue(_instance1.hashCode() == _instance1.hashCode());
		assertTrue(_instance2.hashCode() == _instance2.hashCode());
		assertTrue(_instance3.hashCode() == _instance3.hashCode());
	}

	@Test
	public void testGettersForIdAndName() {
		assertEquals(NAME1, _instance1.getNAME());
		assertEquals(NAME1, _instance2.getNAME());
		assertEquals(NAME3, _instance3.getNAME());

		long id1 = _instance1.getID();
		long id2 = _instance2.getID();
		long id3 = _instance3.getID();
		assertTrue(id1 == _instance1.getID());
		assertTrue(id2 == _instance2.getID());
		assertTrue(id3 == _instance3.getID());
	}

	@Test
	public void testToString() {
		assertTrue(_instance1.toString() instanceof String);
		assertNotNull(_instance1.toString());
	}

	@Test
	public void testGetAndSetConfidenceLevel() {
		ConfidenceLevel confLevel10 = ConfidenceLevel
				.getConfidenceLevelByIntTimes10(10);
		ConfidenceLevel confLevel0 = ConfidenceLevel
				.getConfidenceLevelByIntTimes10(0);
		ConfidenceLevel confLevel100 = ConfidenceLevel
				.getConfidenceLevelByIntTimes10(100);
		ConfidenceLevel confLevel84 = ConfidenceLevel
				.getConfidenceLevelByIntTimes10(84);

		assertEquals(confLevel10, _instance1.getConfidenceLevel());
		assertTrue(10 == _instance1.getConfidenceLevel().getValueTimes10());
		assertEquals(confLevel10, _instance2.getConfidenceLevel());
		assertTrue(10 == _instance2.getConfidenceLevel().getValueTimes10());
		assertEquals(confLevel10, _instance3.getConfidenceLevel());
		assertTrue(10 == _instance3.getConfidenceLevel().getValueTimes10());

		_instance1.setConfidenceLevel(confLevel0);
		assertEquals(confLevel0, _instance1.getConfidenceLevel());
		assertTrue(0 == _instance1.getConfidenceLevel().getValueTimes10());

		_instance1.setConfidenceLevel(confLevel100);
		assertEquals(confLevel100, _instance1.getConfidenceLevel());
		assertTrue(100 == _instance1.getConfidenceLevel().getValueTimes10());

		_instance1.setConfidenceLevel(confLevel84);
		assertEquals(confLevel84, _instance1.getConfidenceLevel());
		assertTrue(84 == _instance1.getConfidenceLevel().getValueTimes10());
	}

}
