/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainvalues;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * Test fr die Klasse: {@link AverageReview}
 * 
 * @author Jens Bothur
 */
public class AverageReviewTest {

	@Test
	public void testGetAllAveragRevuewsByInt() {
		for (int i = 10; i <= 50; i++) {
			assertNotNull(AverageReview.getAverageReviewByIntTimes10(i));
		}

		boolean exception = false;
		try {

			AverageReview.getAverageReviewByIntTimes10(9);
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		assertTrue("There should have been an IllegalArgumentException",
				exception);

		exception = false;
		try {

			AverageReview.getAverageReviewByIntTimes10(51);
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		assertTrue("There should have been an IllegalArgumentException",
				exception);
	}

	@Test
	public void testGetAllAverageReviewsByDouble() {
		for (int i = 10; i <= 50; i++) {
			assertNotNull(AverageReview.getAverageReviewByDouble(i / 10.0));
		}
	}

	@Test
	public void testAllAverageReviewsHaveRightIntValue() {
		for (int i = 10; i <= 50; i++) {
			assertTrue(i == AverageReview.getAverageReviewByDouble(i / 10.0)
					.getValueTimes10());
		}
	}

	@Test
	public void testAllAverageReviewsHaveRightDoubleValue() {
		for (int i = 10; i <= 50; i++) {
			assertTrue((i / 10.0) == AverageReview.getAverageReviewByDouble(
					i / 10.0).getValue());
		}
	}

	@Test
	public void testToString() {
		assertTrue(AverageReview.getAverageReviewByIntTimes10(30).toString()
				.equals("AverageReview [3.0]"));
	}

	@Test
	public void testNormalizedRatingisCalculatedRight() {
		assertTrue(0.0 == AverageReview.getAverageReviewByIntTimes10(10)
				.getNormalizedRating());
		assertTrue(0.25 == AverageReview.getAverageReviewByIntTimes10(20)
				.getNormalizedRating());
		assertTrue(0.5 == AverageReview.getAverageReviewByIntTimes10(30)
				.getNormalizedRating());
		assertTrue(0.75 == AverageReview.getAverageReviewByIntTimes10(40)
				.getNormalizedRating());
		assertTrue(1.0 == AverageReview.getAverageReviewByIntTimes10(50)
				.getNormalizedRating());
		assertTrue(0.2 == AverageReview.getAverageReviewByIntTimes10(18)
				.getNormalizedRating());
		assertTrue(0.4 == AverageReview.getAverageReviewByIntTimes10(26)
				.getNormalizedRating());
		assertTrue(0.6 == AverageReview.getAverageReviewByIntTimes10(34)
				.getNormalizedRating());
		assertTrue(0.8 == AverageReview.getAverageReviewByIntTimes10(42)
				.getNormalizedRating());
	}

}
