/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.domainvalues;

import static org.junit.Assert.assertNotNull;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

/**
 * Test fr Klasse {@link ConfidenceLevel}.
 * 
 * @author Jens Bothur
 */
public class ConfidenceLevelTest {

	@Test
	public void testGetAllConfidenceLevelsByInt() {
		for (int i = 0; i <= 100; i++) {
			assertNotNull(ConfidenceLevel.getConfidenceLevelByIntTimes10(i));
		}
		
		boolean exception = false;
		try {

			ConfidenceLevel.getConfidenceLevelByIntTimes10(-1);
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		assertTrue("There should have been an IllegalArgumentException",
				exception);

		exception = false;
		try {

			ConfidenceLevel.getConfidenceLevelByIntTimes10(101);
		} catch (IllegalArgumentException e) {
			exception = true;
		}
		assertTrue("There should have been an IllegalArgumentException",
				exception);
	}

	@Test
	public void testGetAllConfidenceLevelsByDouble() {
		for (int i = 0; i <= 100; i++) {
			assertNotNull(ConfidenceLevel.getConfidenceLevelByDouble(i / 10.0));
		}
	}

	@Test
	public void testAllConfidenceLevelsHaveRightIntValue() {
		for (int i = 0; i <= 100; i++) {
			assertTrue(i == ConfidenceLevel
					.getConfidenceLevelByDouble(i / 10.0).getValueTimes10());
		}
	}

	@Test
	public void testAllConfidenceLevelsHaveRightDoubleValue() {
		for (int i = 0; i <= 100; i++) {
			assertTrue((i / 10.0) == ConfidenceLevel
					.getConfidenceLevelByDouble(i / 10.0).getValue());
		}
	}

}
