/**
 * Bachelorarbeit: Crowdsourcing- Systeme Manipulation und Resistenz
 * von Jens Bothur
 */
package jens.bothur.occt.services;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertNull;
import static org.junit.Assert.assertTrue;

import java.util.Random;

import jens.bothur.occt.domainobjects.User;

import org.junit.Before;
import org.junit.Test;

/**
 * Test fr Klasse: {@link DummyUserService}.
 * 
 * @author Jens Bothur
 */
public class DummyUserServiceTest {

	private DummyUserService _instance;

	private User _user1;
	private User _user2;

	/**
	 * @throws java.lang.Exception
	 */
	@Before
	public void setUp() throws Exception {
		_instance = new DummyUserService();

		_user1 = new User("Derek Jeter");
		_user2 = new User("Mark Texeira");
	}

	@Test
	public void testInitalState() {
		assertTrue(_instance.getAllUsers().isEmpty());

		Random random = new Random(96234);
		for (int i = 0; i < 100; i++) {
			assertNull(_instance.getUser(random.nextLong()));
		}
		assertNull(_instance.getUser(Long.MAX_VALUE));
		assertNull(_instance.getUser(Long.MIN_VALUE));
	}

	@Test
	public void testBasicFunctionsWithRegisterGetAndGetAll() {
		_instance.registerUser(_user1);
		assertTrue(1 == _instance.getAllUsers().size());
		assertTrue(_instance.getAllUsers().contains(_user1));
		assertEquals(_user1, _instance.getUser(_user1.getID()));

		_instance.registerUser(_user1);
		assertTrue(1 == _instance.getAllUsers().size());
		assertTrue(_instance.getAllUsers().contains(_user1));
		assertEquals(_user1, _instance.getUser(_user1.getID()));

		_instance.registerUser(_user2);
		assertTrue(2 == _instance.getAllUsers().size());
		assertTrue(_instance.getAllUsers().contains(_user1));
		assertTrue(_instance.getAllUsers().contains(_user2));
		assertEquals(_user1, _instance.getUser(_user1.getID()));
		assertEquals(_user2, _instance.getUser(_user2.getID()));

		_instance.registerUser(_user1);
		_instance.registerUser(_user2);
		assertTrue(2 == _instance.getAllUsers().size());
		assertTrue(_instance.getAllUsers().contains(_user1));
		assertTrue(_instance.getAllUsers().contains(_user2));
		assertEquals(_user1, _instance.getUser(_user1.getID()));
		assertEquals(_user2, _instance.getUser(_user2.getID()));

	}

}
