package edu.ubb.scp.dao;

import java.util.ArrayList;

import edu.ubb.scp.exception.UnsafeException;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Order;

public interface BaseDAO {
	/**
	 * Stores a model in the database, updates the primary key in the Model object (if it is the case)
	 * @param model the model to be stored in the database
	 */
	void insert(Model model);
	/**
	 * Stores an order in the database, updates the primary key in the Order object (if it is the case)
	 * @param model the order to be stored in the database
	 */
	void insertSafe(Order model) throws UnsafeException;
	/**
	 * Deletes a model from the database identifying it by the keys
	 * @param model the model to be deleted from the database
	 */
	void delete(Model model);
	/**
	 * Updates a model in the database identifying it by the keys
	 * @param model the model to be updated in the database
	 */
	void update(Model model);
	/**
	 * Selects a list of model objects
	 * @param model the class of the model objects
	 * @param where the search conditions, everything that would go after WHERE in an sql statement
	 * @return ArrayList of Models, consisting of individual objects of model type
	 */
	ArrayList<Model> select(Class<? extends Model> model, String where);

	/**
	 * Selects a list of model objects
	 * @param model the class of the model objects
	 * @return ArrayList of Models, consisting of individual objects of model type
	 */
	ArrayList<Model> select(Class<? extends Model> model);
}
