package edu.ubb.scp.dao;

import edu.ubb.scp.dao.jdbc.JdbcDAOFactory;
/**
 * The creator of all things DAO.<br /><br />
 * <b>Usage: </b><br />
 * DAOFactory factory = DAOFactory.<i>getInstance</i>();<br />
 * <span style="color: #700;">ModelClassName</span>DAO dao = 
 * factory.get<span style="color: #700;">ModelClassName</span>DAO();<br />
 * <span style="color: #700;">ModelClassName</span> object = 
 * dao.get<span style="color: #700;">ModelClassName</span>from<span style="color: #700;">Attribute</span>(attribute)
 * <br /><br />
 * @author Balazs
 *
 */
public abstract class DAOFactory {
	public static DAOFactory getInstance() {
		return new JdbcDAOFactory();
	}

	public abstract BaseDAO getBaseDAO();
}
