package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Customer;

public class CustomerSelector extends JFrame{
	
	private BaseGui gui;
	private JPanel buttonPane = new JPanel(new FlowLayout());
	private JPanel contentPane = new JPanel(new BorderLayout());
	private JScrollPane tablePane = new JScrollPane();
	private JTable table;
	
	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();
	
	public CustomerSelector(final BaseGui gui) {
		//super(gui);
		this.gui = gui;
		setSize(350, 450);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		init();
		
	}
	
	protected void init() {
		buttonPane.removeAll();
		contentPane.removeAll();
		contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		setContentPane(contentPane);
		table = TableLoader.getCustomers();
		
		JButton setCustomer = new JButton("Set Customer");
		setCustomer.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
			
				Customer c = (Customer) (bd.select(Customer.class, "CuStomerID = " +	Integer.toString((Integer)table.getValueAt(table.getSelectedRow(), 0)))).get(0);
				gui.setCustomer(c);
				dispose();
				
			}
		});
		
		JButton newCustomer = new JButton("New Customer");
		newCustomer.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				addInserter();
				
			}
		});
		
		buttonPane.add(setCustomer);
		buttonPane.add(newCustomer);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane,BorderLayout.NORTH);
		
		
		
		setVisible(true);
	}
	
	private void addInserter() {
		new SimpleInserter(this, "Customer");
	}
	
}
