package edu.ubb.scp.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.logic.Password;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Table;

public class LoginGui extends JFrame {

	private JPanel contentPane;
	private JComboBox tableCombo;
	private JLabel passwordLabel = new JLabel("Password: ");
	private JPasswordField passwordField = new JPasswordField(10);
	private JButton loginButton = new JButton("Log in");

	public LoginGui() {

		initCombo();
		initListener();
		contentPane = new JPanel();
		contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));

		GridBagLayout gb = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();

		contentPane.setLayout(gb);

		c.gridwidth = GridBagConstraints.RELATIVE;
		c.insets = new Insets(10, 10, 5, 0);
		gb.setConstraints(passwordLabel, c);
		contentPane.add(passwordLabel);

		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(10, 0, 5, 10);
		gb.setConstraints(passwordField, c);
		contentPane.add(passwordField);

		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(10, 10, 5, 10);
		c.anchor = GridBagConstraints.CENTER;
		gb.setConstraints(tableCombo, c);
		contentPane.add(tableCombo);

		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(10, 10, 5, 10);
		c.anchor = GridBagConstraints.CENTER;
		gb.setConstraints(loginButton, c);
		contentPane.add(loginButton);

		passwordField.setEchoChar('*');

		setSize(250, 180);
		setContentPane(contentPane);
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setVisible(true);
	}

	private void initCombo() {
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();

		ArrayList<Model> tableList = bd.select(Table.class);
		String[] t = new String[tableList.size() + 1];
		for (int i = 0; i < tableList.size(); i++) {
			t[i] = Integer.toString(((Table) tableList.get(i)).getTableID());
		}
		t[tableList.size()] = "Management";
		tableCombo = new JComboBox(t);
	}

	private void initListener() {
		loginButton.addActionListener(new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {

				String pass = String.copyValueOf(passwordField.getPassword());
				System.out.println(pass);
				if (Password.valid(pass)) {
					if ("Management" == (String) tableCombo.getSelectedItem()) {
						System.out.println("Managing yo ass!");
						new ManageGui();
						dispose();
					} else {
						
						int x = Integer.parseInt((String) tableCombo
								.getSelectedItem());
						(new CustomerGui()).setTable(x);
						System.out.println(x);
						dispose();
					}
				} else {
					showError();
				}
			}
		});
	}
	
	private void showError() {
		JOptionPane.showMessageDialog(this, "The password you have input is invalid", "Invalid Password", JOptionPane.ERROR_MESSAGE);
	}

}
