package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;

import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.logic.Bill;
import edu.ubb.scp.logic.XML;
import edu.ubb.scp.model.Game;
import edu.ubb.scp.model.GameBrand;
import edu.ubb.scp.model.GameType;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Product;
import edu.ubb.scp.model.ProductBrand;
import edu.ubb.scp.model.ProductType;
import edu.ubb.scp.model.Provider;
import edu.ubb.scp.model.Test;

public class ManageGui extends BaseGui {
	
	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();
	private JLabel selectedCustomer = new JLabel("");
	
	public ManageGui() {
		initMenuBar();
		initManageGame();
		setVisible(true);
	}
	
	private void initMenuListener() {
		menuListener = new ActionListener() {

			@Override
			public void actionPerformed(ActionEvent e) {

				String comm = e.getActionCommand();

				if (comm == "Manage drinks") {
					initManageProduct();
				}
				
				if (comm == "Manage games") {
					initManageGame();
				}
				
				if (comm == "Manage game type") {
					initManageGameType();
				}
				
				if (comm == "Get XML") {
					getXML();
				}
				
				if (comm == "Manage games type") {
					initManageGameType();
				}
				
				if (comm == "Manage games brand") {
					initManageGameBrand();
				}
				
				if (comm == "Manage drink types") {
					initManageProductType();
				}
				
				if (comm == "Manage drink brands") {
					initManageProductBrand();
				}
				
				if (comm == "Manage providers") {
					initManageProvider();
				}
				
				if (comm == "Product Orders") {
					initManageProductOrder();
				}
				
				if (comm == "Manage tests") {
					initManageTest();
				}
				
			}
		};
	}

	private void initMenuBar() {

		initMenuListener();

		JMenu menu = new JMenu("Drinks");
		menu.setMnemonic(KeyEvent.VK_D);
		menuBar.add(menu);

		createMenuItem(menu, "Manage drinks", KeyEvent.VK_M, "Manage drinks");
		createMenuItem(menu, "Manage providers", KeyEvent.VK_M, "Manage providers");
		createMenuItem(menu, "Manage drink types", KeyEvent.VK_M, "Manage drink types");
		createMenuItem(menu, "Manage drink brands", KeyEvent.VK_M, "Manage drink brands");
		createMenuItem(menu, "Manage tests", KeyEvent.VK_M, "Manage tests");

		 
		//createMenuItem(menu, "Order drinks", KeyEvent.VK_O, "Order drinks");

		menu = new JMenu("Games");
		menu.setMnemonic(KeyEvent.VK_G);
		menuBar.add(menu);

		createMenuItem(menu, "Manage games", KeyEvent.VK_M, "Manage games");
		createMenuItem(menu, "Manage games brand", KeyEvent.VK_M, "Manage games brand");
		createMenuItem(menu, "Manage games type", KeyEvent.VK_M, "Manage games type");
		//createMenuItem(menu, "Order games", KeyEvent.VK_O, "Order games");

		menu = new JMenu("Orders");
		menu.setMnemonic(KeyEvent.VK_G);
		menuBar.add(menu);

		createMenuItem(menu, "Orders", KeyEvent.VK_C, "Product Orders");
		createMenuItem(menu, "Get XML", KeyEvent.VK_X, "Get XML");

	}
	
	protected void initManageGame() {
		
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getGameTable();
		tablePane.setViewportView(table);
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Game g = (Game) bd.select(Game.class, "GameID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(g);
				initManageGame();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				addComplexInserter("Game");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageProduct() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Product g = (Product) bd.select(Product.class, "ProductID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(g);
				initManageProduct();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				addComplexInserter("Product");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		table = TableLoader.getProductsTable();
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageGameType() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getGameType();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(GameType.class, "GameTypeID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageGameType();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				addSimpleInserter("Game Type");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageGameBrand() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getGameBrand();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(GameBrand.class, "GameBrandID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageGameBrand();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				addSimpleInserter("Game Brand");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageProductType() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getProductType();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(ProductType.class, "ProductTypeID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageProductType();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				addSimpleInserter("Product Type");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageProductBrand() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getProductBrand();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(ProductBrand.class, "ProductBrandID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageProductBrand();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				addSimpleInserter("Product Brand");
				
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	protected void initManageProvider() {
		
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getProviderLong();
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(Provider.class, "ProviderID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageProvider();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				addProviderInserter();
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
		
	}
	
	protected void initManageProductOrder() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getProductOrder();
		JLabel customerLabel = null;
		
		try {
			customerLabel = new JLabel("Current customer: " + currentCustomer.getCustomerName()); 
		
		} catch (Exception e) {
			customerLabel = new JLabel("Current customer: ");
		}
		JButton selectCustomer = new JButton("Set current Customer");
		selectCustomer.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				setCustomer();
				
			}
		});
		
		JButton billMurray = new JButton("Bill");
		billMurray.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				
				Bill b = new Bill(currentCustomer);
				
				JTextArea billText = new JTextArea(b.toString());
				billText.setAutoscrolls(true);
				billText.setEditable(false);
				
				JOptionPane.showMessageDialog(null, billText);
				
				b.pay();
				initManageProductOrder();
				
			}
		});
		
		buttonPane.add(customerLabel);
		buttonPane.add(billMurray);
		buttonPane.add(selectCustomer);
		buttonPane.add(selectCustomer);
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
		
	}
	
	private void initManageTest() {
		contentPane.removeAll();
		buttonPane.removeAll();
		
		table = TableLoader.getTests();
		
		
		JButton delete = new JButton("Delete");
		delete.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
				
				Model m = bd.select(Test.class, "TestID =" + Integer.toString(
						((Integer) (table.getValueAt(table.getSelectedRow(), 0))))).get(0);
				bd.delete(m);
				initManageTest();
			}
		});
		
		JButton insert = new JButton("Insert");
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent e) {
				addSimpleInserter("Test");
			}
		});
		
		buttonPane.add(delete);
		buttonPane.add(insert);
		
		
		tablePane.setViewportView(table);
		contentPane.add(tablePane, BorderLayout.CENTER);
		contentPane.add(buttonPane, BorderLayout.NORTH);
		setVisible(true);
	}
	
	private void setCustomer() {
		new CustomerSelector(this);
		selectedCustomer.setText("Current customer: " + currentCustomer.getCustomerName());
		
	}
	
	private void addComplexInserter(String type) {
		new ComplexInserter(this, type);
	}
	
	private void addSimpleInserter(String type) {
		new SimpleInserter(this, type);
	}
	
	private void addProviderInserter() {
		new ProviderInserter(this);
	}
	
	private void getXML() {
		final JFileChooser fc = new JFileChooser();
		int returnVal = fc.showOpenDialog(this);
		if (returnVal == JFileChooser.APPROVE_OPTION) {
			File file = fc.getSelectedFile();
			String s = file.getAbsolutePath();
			XML.exportProducts(s);
		}
	}

	@Override
	protected void updateCustomer() {
		initManageProductOrder();
	}

}
