package edu.ubb.scp.gui;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Provider;

public class ProviderInserter extends JDialog {
	
	private JPanel contentPane = new JPanel();
	private JLabel nameLabel = new JLabel("Enter provider name:  ");
	private JLabel addressLabel = new JLabel("Enter provider address:  ");
	private JLabel telLabel = new JLabel("Enter provider phone number:  ");
	
	private JTextField nameField = new JTextField(20);
	private JTextField addressField = new JTextField(20);
	private JTextField telField = new JTextField(20);
	
	private JButton insert = new JButton("Insert");
	
	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();
	
	private ManageGui parent;
	
	public ProviderInserter(ManageGui p) {
		super(p,true);
		parent = p;
		setSize(400,250);
		
		contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		
		GridBagLayout gb = new GridBagLayout();
		GridBagConstraints c = new GridBagConstraints();
		
		contentPane.setLayout(gb);
		setContentPane(contentPane);
		
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.insets = new Insets(10, 10, 5, 0);
		gb.setConstraints(nameLabel, c);
		contentPane.add(nameLabel);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(10, 0, 5, 10);
		gb.setConstraints(nameField, c);
		contentPane.add(nameField);
		
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.insets = new Insets(0, 10, 10, 0);
		gb.setConstraints(addressLabel, c);
		contentPane.add(addressLabel);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(0, 0, 10, 10);
		gb.setConstraints(addressField, c);
		contentPane.add(addressField);
		
		c.gridwidth = GridBagConstraints.RELATIVE;
		c.insets = new Insets(10, 10, 5, 0);
		gb.setConstraints(telLabel, c);
		contentPane.add(telLabel);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(0, 0, 0, 10);
		gb.setConstraints(telField, c);
		contentPane.add(telField);
		
		c.gridwidth = GridBagConstraints.REMAINDER;
		c.insets = new Insets(10, 10, 5, 10);
		c.anchor = GridBagConstraints.CENTER;
		gb.setConstraints(insert, c);
		contentPane.add(insert);
		
		initButton();
		
		setDefaultCloseOperation(DISPOSE_ON_CLOSE);
		setVisible(true);
	}
	
	private void initButton() {
		
		insert.addActionListener(new ActionListener() {
			
			@Override
			public void actionPerformed(ActionEvent arg0) {
			
				Provider p = new Provider(nameField.getText(), addressField.getText(), telField.getText());
				bd.insert(p);
				
				((ManageGui) parent).initManageProvider();
				
			}
		});
		
	}
	
	
}
