package edu.ubb.scp.gui;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Customer;
import edu.ubb.scp.model.GameBrand;
import edu.ubb.scp.model.GameType;
import edu.ubb.scp.model.ProductBrand;
import edu.ubb.scp.model.ProductType;
import edu.ubb.scp.model.Test;

public class SimpleInserter extends JDialog {

	/**
	 * 
	 */
	private static final long serialVersionUID = -4128230289177188083L;
	private JTextField insertfield = new JTextField(15);
	private JButton insertButton;
	private JPanel insertPane;
	private DAOFactory df = DAOFactory.getInstance();
	private BaseDAO bd = df.getBaseDAO();
	private ManageGui parent;
	private JFrame parentF;
	

	public SimpleInserter(JFrame p, String type) {

		super(p, type + " Inserter", true);
		setSize(350, 125);
		setResizable(false);
		try {
			this.parent = (ManageGui) p;
		} catch (Exception e) {
			
		}
		parentF = p;

		insertButton = new JButton("Insert " + type);

		GridBagLayout gbl = new GridBagLayout();
		GridBagConstraints gbc = new GridBagConstraints();

		insertPane = new JPanel();
		insertPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
		insertPane.setLayout(gbl);
		setContentPane(insertPane);

		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.insets = new Insets(10, 10, 5, 10);
		gbl.setConstraints(insertfield, gbc);
		insertPane.add(insertfield);

		gbc.gridwidth = GridBagConstraints.REMAINDER;
		gbc.insets = new Insets(10, 10, 5, 10);
		gbc.anchor = GridBagConstraints.CENTER;
		gbl.setConstraints(insertButton, gbc);
		insertPane.add(insertButton);

		

		if (type.equals("Game Brand")){
			insertButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					GameBrand pt = new GameBrand(s);
					bd.insert(pt);
					System.out.println(s);
					parent.initManageGameType();
				}
			});
		}

		if (type.equals("Game Type")) {
			insertButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					GameType pt = new GameType(s);
					bd.insert(pt);
					System.out.println(s);
					parent.initManageGameType();
				}
			});
		}

		if (type == "Product Brand") {
			insertButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					ProductBrand pb = new ProductBrand(s);
					bd.insert(pb);
					System.out.println(s);
					parent.initManageProductBrand();
				}
			});
		}

		if (type == "Product Type") {
			insertButton.addActionListener(new ActionListener() {

				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					ProductType pt = new ProductType(s);
					bd.insert(pt);
					System.out.println(s);
					parent.initManageProductType();
				}
			});
		}
		
		if (type == "Customer") {
			insertButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					Customer c = new Customer(s, 0.0f);
					bd.insert(c);
					((CustomerSelector) parentF).init();
					dispose();
					
				}
			});
		}
		
		if (type == "Test") {
			
			final JTextField nameField = new JTextField("Test Name");
			final JTextField dataField = new JTextField("Test Data");
			insertfield.setText("Test Answer");
			
			gbc.gridwidth = GridBagConstraints.CENTER;
			gbc.insets = new Insets(15, 10, 5, 10);
			gbl.setConstraints(insertfield, gbc);
			insertPane.add(nameField,0);

			gbc.gridwidth = GridBagConstraints.CENTER;
			gbc.insets = new Insets(15, 10, 5, 10);
			gbl.setConstraints(insertfield, gbc);
			insertPane.add(dataField,1);
			
			setSize(850, 150);
			
			insertButton.addActionListener(new ActionListener() {
				
				@Override
				public void actionPerformed(ActionEvent arg0) {
					String s = insertfield.getText();
					Test c = new Test(nameField.getText(), dataField.getText(), insertfield.getText());
					bd.insert(c);
					//((CustomerSelector) parentF).init();
					dispose();
					
				}
			});
			
		}

		setVisible(true);
	}

}
