package edu.ubb.scp.gui;

import java.text.DecimalFormat;
import java.util.ArrayList;

import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumnModel;

import edu.ubb.scp.dao.BaseDAO;
import edu.ubb.scp.dao.DAOFactory;
import edu.ubb.scp.model.Customer;
import edu.ubb.scp.model.Game;
import edu.ubb.scp.model.GameBrand;
import edu.ubb.scp.model.GameType;
import edu.ubb.scp.model.Model;
import edu.ubb.scp.model.Order;
import edu.ubb.scp.model.Product;
import edu.ubb.scp.model.ProductBrand;
import edu.ubb.scp.model.ProductType;
import edu.ubb.scp.model.Provider;
import edu.ubb.scp.model.Test;

public class TableLoader {
	
	public static JTable getProductsTable() {
		JTable table = new JTable();
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		
		ArrayList<Model> productList = bd.select(Product.class);
		
		String[] columns = new String[] {
				"ID",
				"Name",
				"Brand",
				"Type",
				"Provider",
				"Stock",
				"Price"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		for (Model m : productList) {
			Product p = (Product) m;
			ProductBrand b = (ProductBrand) bd.select(ProductBrand.class, "ProductBrandID = " + Integer.toString(p.getProductBrandID())).get(0);
			ProductType t = (ProductType) bd.select(ProductType.class, "ProductTypeID = " + Integer.toString(p.getProductTypeID())).get(0);
			Provider provider = (Provider) bd.select(Provider.class, "ProviderID = " + Integer.toString(p.getProviderID())).get(0);
			Object[] row = new Object[] {
					p.getProductID(),
					p.getProductName(),
					b.getProductBrandName(),
					t.getProductTypeName(),
					provider.getProviderName(),
					p.getStock(),
					p.getPrice()
					
			};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		return table;
	}
	
	public static JTable getGameTable() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		
		ArrayList<Model> gameList = bd.select(Game.class);
		
		String[] columns = new String[] {
				"ID",
				"Name",
				"Brand",
				"Type"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		for (Model m : gameList) {
			Game g = (Game) m;
			GameBrand gb = (GameBrand) bd.select(GameBrand.class, "GameBrandID = " + Integer.toString(g.getGameBrandID())).get(0);
			GameType gt = (GameType) bd.select(GameType.class, "GameTypeID = " + Integer.toString(g.getGameTypeID())).get(0);
			Object[] row = new Object[] {
					g.getGameID(),
					g.getGameName(),
					gb.getGameBrandName(),
					gt.getGameTypeName()
			};
			
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		return table;
	}
	
	public static JTable getAvailableGameTable() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		
		ArrayList<Model> gameList = bd.select(Game.class , "not (gameid in (SELECT GAMEID FROM GAMEORDER))");
		
		String[] columns = new String[] {
				"ID",
				"Name",
				"Brand",
				"Type"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		for (Model m : gameList) {
			Game g = (Game) m;
			GameBrand gb = (GameBrand) bd.select(GameBrand.class, "GameBrandID = " + Integer.toString(g.getGameBrandID())).get(0);
			GameType gt = (GameType) bd.select(GameType.class, "GameTypeID = " + Integer.toString(g.getGameTypeID())).get(0);
			Object[] row = new Object[] {
					g.getGameID(),
					g.getGameName(),
					gb.getGameBrandName(),
					gt.getGameTypeName()
			};
			
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		table.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);
		
		return table;
	}
	
	public static JTable getReceipt(ArrayList<Integer> pCart, ArrayList<Integer> gCart) {
		JTable table = new JTable();
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		Float price = 0.0f;
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"Name",
				"Price"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		for (Integer i : pCart) {
			Product p = (Product) bd.select(Product.class, "ProductID = " + Integer.toString(i)).get(0);
			Object[] row = new Object[] {
					p.getProductName(),
					p.getPrice()
			};
			price += p.getPrice();
			model.addRow(row);
		}
		
		for (Integer i : gCart) {
			Game p = (Game) bd.select(Game.class, "GameID = " + Integer.toString(i)).get(0);
			Object[] row = new Object[] {
					p.getGameName(),
					0
			};
			model.addRow(row);
		}
		DecimalFormat formatter = new DecimalFormat("0.00");
		Object[] row = new Object[] {
				"Total",
				formatter.format(price),
		};
		model.addRow(row);
		
		table.setModel(model);
		
		return table;
	}
	
	public static JTable getProductType() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Type"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(ProductType.class);
		
		for (Model m : list) {
			ProductType item = (ProductType) m;
			Object[] row = new Object[] {
					item.getProductTypeID(),
					item.getProductTypeName(),
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}

	public static JTable getProductBrand() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Brand"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(ProductBrand.class);
		
		for (Model m : list) {
			ProductBrand item = (ProductBrand) m;
			Object[] row = new Object[] {
					item.getProductBrandID(),
					item.getProductBrandName(),
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
	public static JTable getGameType() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Type"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(GameType.class);
		
		for (Model m : list) {
			GameType item = (GameType) m;
			Object[] row = new Object[] {
					item.getGameTypeID(),
					item.getGameTypeName(),
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}

	public static JTable getGameBrand() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Brand"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(GameBrand.class);
		
		for (Model m : list) {
			GameBrand item = (GameBrand) m;
			Object[] row = new Object[] {
					item.getGameBrandID(),
					item.getGameBrandName(),
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
	public static JTable getProviderSimple() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"ProviderName"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(Provider.class);
		
		for (Model m : list) {
			Provider item = (Provider) m;
			Object[] row = new Object[] {
					item.getProviderID(),
					item.getProviderName(),
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
	public static JTable getProviderLong() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Provider Name",
				"Provider Adress",
				"Provider Contact"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(Provider.class);
		
		for (Model m : list) {
			Provider item = (Provider) m;
			Object[] row = new Object[] {
					item.getProviderID(),
					item.getProviderName(),
					item.getProviderAddress(),
					item.getProviderTel()
					};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
	public static JTable getProductOrder() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Product",
				"Quantity",
				"Table",
				"Customer",
				"CustomerID"
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(Order.class);
		
		for (Model m : list) {
			Order o = (Order) m;
			Product p = (Product) bd.select(Product.class, "ProductID = " + Integer.toString((Integer)o.getProductID())).get(0);
			Customer c = (Customer) bd.select(Customer.class, "CustomerID = " + Integer.toString((Integer)o.getCustomerID())).get(0);
			Object[] row = new Object[] {
					o.getOrderID(),
					p.getProductName(),
					o.getQuantity(),
					o.getTableID(),
					c.getCustomerName(),
					c.getCustomerID()
			};
			model.addRow(row);
			
		}
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		table.getColumn("CustomerID").setWidth(0);
		table.getColumn("CustomerID").setMinWidth(0);
		table.getColumn("CustomerID").setMaxWidth(0);		
			
		
		return table;
	}
	
	public static JTable getCustomers() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Customer Name",
				"Tab",
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(Customer.class);
		
		for (Model m : list) {
			Customer c = (Customer) m;
			Object[] row = new Object[] {
					c.getCustomerID(),
					c.getCustomerName(),
					c.getCustomerTab()
			};
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
	public static JTable getTests() {
		JTable table = new JTable();
		
		DAOFactory df = DAOFactory.getInstance();
		BaseDAO bd = df.getBaseDAO();
		
		DefaultTableModel model = new DefaultTableModel();
		String[] columns = new String[] {
				"ID",
				"Test Name",
				"Test Data",
				"Answer",
		};
		
		model.setColumnCount(columns.length);
		model.setColumnIdentifiers(columns);
		
		ArrayList<Model> list = bd.select(Test.class);
		
		for (Model m : list) {
			Test t = (Test) m;
			Object[] row = new Object[] {
					t.getTestID(),
					t.getTestName(),
					t.getData(),
					t.getAnswer()
			};
			
			model.addRow(row);
		}
		
		table.setModel(model);
		table.getColumn("ID").setWidth(0);
		table.getColumn("ID").setMinWidth(0);
		table.getColumn("ID").setMaxWidth(0);
		
		return table;
	}
	
}
