package edu.ubb.scp.model;

import java.lang.reflect.Field;

public class Order implements Model {
	private int OrderID;
	private int Quantity;
	private int ProductID;
	private int TableID;
	private int CustomerID;

	public Order(int quantity, int productID, int tableID, int customerID) {
		super();
		Quantity = quantity;
		ProductID = productID;
		TableID = tableID;
		CustomerID = customerID;
	}

	public Order() {

	}

	public int getOrderID() {
		return OrderID;
	}

	public void setOrderID(int orderID) {
		OrderID = orderID;
	}

	public int getQuantity() {
		return Quantity;
	}

	public void setQuantity(int quantity) {
		Quantity = quantity;
	}

	public int getProductID() {
		return ProductID;
	}

	public void setProductID(int productID) {
		ProductID = productID;
	}

	public int getTableID() {
		return TableID;
	}

	public void setTableID(int tableID) {
		TableID = tableID;
	}

	public int getCustomerID() {
		return CustomerID;
	}

	public void setCustomerID(int customerID) {
		CustomerID = customerID;
	}

	@Override
	public String toString() {
		return "Order [OrderID=" + OrderID + ", Quantity=" + Quantity
				+ ", ProductID=" + ProductID + ", TableID=" + TableID
				+ ", CustomerID=" + CustomerID + "]";
	}

	@Override
	public Field getPrimaryKey() {
		try {
			return Order.class.getDeclaredField("OrderID");
		} catch (NoSuchFieldException e) {
			e.printStackTrace();
		} catch (SecurityException e) {
			e.printStackTrace();
		}
		return null;
	}

	@Override
	public Field[] getKeys() {
		return new Field[] { getPrimaryKey() };
	}

}
