/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package senai.cronos.gui;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JDialog;
import senai.cronos.entidades.Turma;
import senai.cronos.entidades.UnidadeCurricular;
import senai.cronos.gui.custom.LinkEffectHandler;
import senai.cronos.gui.custom.ucCheck;
import senai.cronos.util.Acumulador;
import senai.cronos.util.TurmasConfig;
import senai.util.concurrency.Paralell;

/**
 *
 * @author Sergio e Carlos Melo
 */
public class CheckDisciplina extends javax.swing.JPanel {

    List<UnidadeCurricular> lu;
    List<ucCheck> check;
    private Turma turma;
    private Acumulador acc = new Acumulador();

    /**
     *
     * @param container
     * @param check
     * @param turma
     */
    public CheckDisciplina(JDialog container, List<ucCheck> check, Turma turma, Acumulador acc) {
        initComponents();
        lbOK.addMouseListener(new LinkEffectHandler());
        this.check = check;
        this.container = container;
        this.turma = turma;
        this.alocateUnidadesCurriculares(check);
        this.acc = acc;

    }

    public void setCheck(List<ucCheck> check) {
        this.check.addAll(check);
    }

    public void setTurma(Turma turma) {
        this.turma = turma;
    }

    public void setContainer(JDialog container) {
        this.container = container;
    }

    /**
     * Aloca as disciplinas na aba dedicada de cada modulo
     *
     * @param sliders
     */
    private void alocateUnidadesCurriculares(final List<ucCheck> check) {
        Paralell.start(new Runnable() {
            @Override
            public void run() {
                List<UnidadeCurricular> ul = new TurmasConfig().importar(turma.getNome());

                if (ul == null) {
                }
                for (ucCheck u : check) {
                    int mod = u.getU().getModulo();
                    for (UnidadeCurricular ui : ul) {
                        if (u.getNomeUc().equals(ui.getNome())) {
                            u.setCheckUc(true);
                        }
                    }
                    switch (mod) {
                        case 1:
                            pnProficiencias.add(u);
                            break;
                        case 2:
                            pnProficiencias2.add(u);
                            break;
                        case 3:
                            pnProficiencias3.add(u);
                            break;
                        case 4:
                            pnProficiencias4.add(u);
                            break;
                    }

                }
            }
        });
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        lbOK = new javax.swing.JLabel();
        lbstatus = new javax.swing.JLabel();
        abaProficiencias = new javax.swing.JTabbedPane();
        magicScroll1 = new br.ufrpe.bcc.continuous.components.MagicScroll();
        pnProficiencias = new javax.swing.JPanel();
        magicScroll2 = new br.ufrpe.bcc.continuous.components.MagicScroll();
        pnProficiencias2 = new javax.swing.JPanel();
        magicScroll3 = new br.ufrpe.bcc.continuous.components.MagicScroll();
        pnProficiencias3 = new javax.swing.JPanel();
        magicScroll4 = new br.ufrpe.bcc.continuous.components.MagicScroll();
        pnProficiencias4 = new javax.swing.JPanel();
        acumulador = new javax.swing.JLabel();

        setMaximumSize(new java.awt.Dimension(650, 447));
        setMinimumSize(new java.awt.Dimension(650, 447));

        lbOK.setFont(new java.awt.Font("Segoe UI", 0, 14)); // NOI18N
        lbOK.setHorizontalAlignment(javax.swing.SwingConstants.CENTER);
        java.util.ResourceBundle bundle = java.util.ResourceBundle.getBundle("senai/cronos/gui/Bundle"); // NOI18N
        lbOK.setText(bundle.getString("CheckDisciplina.lbOK.text")); // NOI18N
        lbOK.setBorder(javax.swing.BorderFactory.createLineBorder(new java.awt.Color(102, 102, 102)));
        lbOK.addMouseListener(new java.awt.event.MouseAdapter() {
            public void mouseClicked(java.awt.event.MouseEvent evt) {
                lbOKMouseClicked(evt);
            }
        });

        lbstatus.setFont(new java.awt.Font("Segoe UI", 0, 14)); // NOI18N
        lbstatus.setHorizontalAlignment(javax.swing.SwingConstants.RIGHT);
        lbstatus.setText(bundle.getString("CheckDisciplina.lbstatus.text")); // NOI18N

        magicScroll1.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

        pnProficiencias.setMaximumSize(new java.awt.Dimension(630, 32767));
        pnProficiencias.setMinimumSize(new java.awt.Dimension(630, 350));
        pnProficiencias.setPreferredSize(new java.awt.Dimension(630, 1300));
        magicScroll1.setViewportView(pnProficiencias);

        abaProficiencias.addTab(bundle.getString("CheckDisciplina.magicScroll1.TabConstraints.tabTitle"), magicScroll1); // NOI18N

        magicScroll2.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

        pnProficiencias2.setMaximumSize(new java.awt.Dimension(630, 32767));
        pnProficiencias2.setMinimumSize(new java.awt.Dimension(630, 350));
        pnProficiencias2.setPreferredSize(new java.awt.Dimension(630, 1300));
        magicScroll2.setViewportView(pnProficiencias2);

        abaProficiencias.addTab(bundle.getString("CheckDisciplina.magicScroll2.TabConstraints.tabTitle"), magicScroll2); // NOI18N

        magicScroll3.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

        pnProficiencias3.setMaximumSize(new java.awt.Dimension(630, 32767));
        pnProficiencias3.setMinimumSize(new java.awt.Dimension(630, 350));
        pnProficiencias3.setPreferredSize(new java.awt.Dimension(630, 1300));
        magicScroll3.setViewportView(pnProficiencias3);

        abaProficiencias.addTab(bundle.getString("CheckDisciplina.magicScroll3.TabConstraints.tabTitle"), magicScroll3); // NOI18N

        magicScroll4.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_AS_NEEDED);

        pnProficiencias4.setMaximumSize(new java.awt.Dimension(630, 32767));
        pnProficiencias4.setMinimumSize(new java.awt.Dimension(630, 350));
        pnProficiencias4.setPreferredSize(new java.awt.Dimension(630, 1300));
        magicScroll4.setViewportView(pnProficiencias4);

        abaProficiencias.addTab(bundle.getString("CheckDisciplina.magicScroll4.TabConstraints.tabTitle"), magicScroll4); // NOI18N

        acumulador.setText(bundle.getString("CheckDisciplina.acumulador.text")); // NOI18N

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addComponent(abaProficiencias, javax.swing.GroupLayout.DEFAULT_SIZE, 630, Short.MAX_VALUE)
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(lbOK, javax.swing.GroupLayout.PREFERRED_SIZE, 100, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addGap(18, 18, 18)
                        .addComponent(lbstatus, javax.swing.GroupLayout.PREFERRED_SIZE, 300, javax.swing.GroupLayout.PREFERRED_SIZE)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(acumulador, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .addComponent(abaProficiencias, javax.swing.GroupLayout.DEFAULT_SIZE, 385, Short.MAX_VALUE)
                .addGap(18, 18, 18)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                    .addComponent(lbOK, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(lbstatus, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .addComponent(acumulador, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addContainerGap())
        );
    }// </editor-fold>//GEN-END:initComponents

    private void lbOKMouseClicked(java.awt.event.MouseEvent evt) {//GEN-FIRST:event_lbOKMouseClicked
        new Thread(new Runnable() {
            @Override
            public void run() {
                List<UnidadeCurricular> uc = new ArrayList<>();
                for (ucCheck uk : check) {
                    if (uk.getCheckUc().isSelected()) {
                        uc.add(uk.getU());
                    }
                }
                new TurmasConfig().exportar(turma.getNome(), uc);
                container.dispose();
            }
        }).start();
        lbOK.setVisible(false);
        lbstatus.setText("Atualizando, aguarde...");
        abaProficiencias.removeAll();

    }//GEN-LAST:event_lbOKMouseClicked

    public int getAcumulador() {
        return Integer.parseInt(acumulador.getText());
    }

    public void setAcumulador(int valor) {
        this.acumulador.setText(String.valueOf(Integer.parseInt(acumulador.getText() + valor)));
    }
    private JDialog container;
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JTabbedPane abaProficiencias;
    private javax.swing.JLabel acumulador;
    private javax.swing.JLabel lbOK;
    private javax.swing.JLabel lbstatus;
    private br.ufrpe.bcc.continuous.components.MagicScroll magicScroll1;
    private br.ufrpe.bcc.continuous.components.MagicScroll magicScroll2;
    private br.ufrpe.bcc.continuous.components.MagicScroll magicScroll3;
    private br.ufrpe.bcc.continuous.components.MagicScroll magicScroll4;
    private javax.swing.JPanel pnProficiencias;
    private javax.swing.JPanel pnProficiencias2;
    private javax.swing.JPanel pnProficiencias3;
    private javax.swing.JPanel pnProficiencias4;
    // End of variables declaration//GEN-END:variables
}
