/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost jed dá hadovi jed do jeho laserových střel.
 * Jedové neboli smrtící střely poté vždy po zásahu hada resetují.
 *
 * @author Daniel Vala
 */
public class Jed extends Ability {

	/**
	 * Vytvoří vlastnost jed s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Jed(int sance) {
		super(sance);
	}

	/**
	 * Had získá jedové střely. Tyto střely poté vždy po zásahu hada resetují.
	 *
	 * @param model Model hry.
	 * @param had   Had, který získá jedové střely.
	 * @return Tato vlastnost je vždy úspěšná, proto true.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.isVlastnostJedoveStrely()) {
			model.getPanelZprav().addMessage(String.format("%s si prodloužil dobu, kdy střílí jedové střely!", had));
		} else {
			model.getPanelZprav().addMessage(String.format("%s získal jed do svých střel!", had));
		}
		had.setVlastnostJedoveStrely(true);
		return true;
	}
}
