/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost lopata neboli svoboda umožní hadovi pohybovat se bez obav
 * nárazu do stěny herní plochy.
 * Had se pohybu do stěny zrcadlově objeví na druhé straně herní plochy.
 * Vlastnost není kompatibilní s vlastností pštros.
 *
 * @author Daniel Vala
 */
public class Lopata extends Ability {

	/**
	 * Vytvoří vlastnost lopata s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Lopata(int sance) {
		super(sance);
	}

	/**
	 * Had bude svobodný. Pokud se dostane pryč z herní plochy, objeví se na její druhé straně.
	 * Pokud již had má vlastnost pštros, tuto vlastnost nezíská.
	 *
	 * @param model Model hry.
	 * @param had   Had, který získá svobodu.
	 * @return True, pokud had vlastnost získal. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		// Pokud již had má svobodu nebo pštrosa, nic se nestane.
		if (had.isVlastnostSvoboda() || had.isVlastnostPstros()) {
			return false;
		} else {
			had.setVlastnostSvoboda(true);
		}
		model.getPanelZprav().addMessage(String.format("%s sebral lopatu a je nyní svobodný", had));
		return true;
	}
}
