/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost tank umožní hadovi prorážet hlavou hady ostatní.
 * Při každém takovém průrazu se ale také zkrátí.
 * Vlastonst není kompatibilní s vlastností duch.
 *
 * @author Daniel Vala
 */
public class Tank extends Ability {

	/**
	 * Vytvoří vlastnost tank s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Tank(int sance) {
		super(sance);
	}

	/**
	 * Had se stane tankem a může prorážet všechny ostatní hady.
	 * Při střetu mojí hlavy s jiným hadem se neresetuji já, ale had, do kterého jsem "naboural".
	 *
	 * @param model Model hry.
	 * @param had   Had, který se stane tankem.
	 * @return True, pokud had vlastnost získal. Jinak false.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.isVlastnostDuch()) {
			return false;
		}
		if (had.isVlastnostTank()) {
			model.getPanelZprav().addMessage(String.format("%s si prodloužil dobu vlastnosti tanku", had));
		} else {
			model.getPanelZprav().addMessage(String.format("%s získal vlastnost tank", had));
		}
		had.setVlastnostTank(true);
		return true;
	}
}
