/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastností vesta se had stává neviditelným pro ostatní.
 *
 * @author Daniel Vala
 */
public class Vesta extends Ability {

	/**
	 * Vytvoří vlastnost vesta s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public Vesta(int sance) {
		super(sance);
	}

	/**
	 * Had se stane neviditelným pro všechny ostatní hady (pokud protihráč nehraje na stejném pc).
	 *
	 * @param model Model hry.
	 * @param had   Had, který se stane neviditelným.
	 * @return Had se může stát neviditelný kdykoli, tedy true.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		if (had.isVlastnostNeviditelnost()) {
			model.getPanelZprav().addMessage(String.format("%s získal další maskovací vestu a bude stále neviditelný!", had));
		} else {
			model.getPanelZprav().addMessage(String.format("%s získal maskovací vestu a je nyní neviditelný!", had));
		}
		had.setVlastnostNeviditelnost(true);
		return true;
	}
}
