/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.abilities;

import com.serponix.game.ModelFun;
import com.serponix.game.Snake;

/**
 * Vlastnost zásobník laseru přidá hadovi nový zásobník.
 * Čím více má had zásobníků, tím více může vystřelit laserů najednou.
 *
 * @author Daniel Vala
 */
public class ZasobnikLaseru extends Ability {

	/**
	 * Vytvoří vlastnost zásobník laseru s danou vzácností.
	 *
	 * @param sance Určuje, jak často se bude vlastnost generovat.
	 */
	public ZasobnikLaseru(int sance) {
		super(sance);
	}

	/**
	 * Had získá další zásobník laseru.
	 * Může tedy náraz vystřelit o jeden laser více.
	 *
	 * @param model Model hry.
	 * @param had   Had, který získá další zásobník laseru.
	 * @return Had může získat další zásobník vždy, tedy true.
	 */
	@Override
	public boolean proved(ModelFun model, Snake had) {
		had.addZasobniky(1);
		model.getPanelZprav().addMessage(String.format("%s ziskal %d dalsi zasobnik pro strelu", had, 1));
		return true;
	}
}
