/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.net.Informace;
import com.serponix.settings.GameSettings;
import com.serponix.settings.SnakeAction;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Map;

/**
 * Obsluhuje klávesnici. Pošle serveru stisk jednotlivých kláves klienta.
 *
 * @author Daniel Vala
 */
public class ControllerHracClient extends KeyAdapter {

	private ModelClient model;
	private Map<SnakeAction, Integer> keys;

	/**
	 * Vytvoří controller pro ovládání hada pro hráče na klientovi.
	 *
	 * @param hrac Hráč, který bude controllerem ovládán.
	 */
	public ControllerHracClient(ModelClient model) {
		this.model = model;
		keys = GameSettings.getInstance().getKeysOfGivenPlayer(0); // keys of the first player are used to control the client
	}

	@Override
	public void keyPressed(KeyEvent event) {
		int key = event.getKeyCode();
		if (key == keys.get(SnakeAction.UP)) {
			model.posliPrikazServeru(Informace.NAHORU);
		} else if (key == keys.get(SnakeAction.DOWN)) {
			model.posliPrikazServeru(Informace.DOLU);
		} else if (key == keys.get(SnakeAction.LEFT)) {
			model.posliPrikazServeru(Informace.VLEVO);
		} else if (key == keys.get(SnakeAction.RIGHT)) {
			model.posliPrikazServeru(Informace.VPRAVO);
		} else if (key == keys.get(SnakeAction.FIRE)) {
			model.posliPrikazServeru(Informace.STREL);
		} else if (key == keys.get(SnakeAction.FIRE2)) {
			model.posliPrikazServeru(Informace.STRELR);
		}

		if (key == KeyEvent.VK_P) {
			model.posliPrikazServeru(Informace.PAUZA);
		} else if (key == KeyEvent.VK_ESCAPE) {
			model.ukonciHru();
		} else if (key == KeyEvent.VK_Q) {
			if ((event.getModifiers() & InputEvent.CTRL_MASK) != 0) {
				model.ukonciHru();
			}
		}
	}
}
