/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

/**
 * All game modes in the game.
 *
 * @author Daniel Vala
 */
public enum GameModeEnum {

	CLASSIC_SNAKE("CLASSIC_SNAKE", "CLASSIC HAD"), TRON("TRON", "TRON"), RECORD("RECORD", "REKORD"), HANDICAP("HANDICAP", "HENDIKEP"), FUN_MOD("FUN_MOD", "FUN MÓD"), CLIENT("CLIENT", "KLIENT"), EDITOR("EDITOR", "EDITOR");
	/**
	 * Key of object which is used to translate from String back to the game mode *
	 */
	private String key;
	/**
	 * Visible game mode name in GUI *
	 */
	private String visibleName;

	private GameModeEnum(String key, String visibleName) {
		this.key = key;
		this.visibleName = visibleName;
	}

	/**
	 * Return key of the object as a String.
	 *
	 * @return key of the object.
	 */
	public String getKey() {
		return key;
	}

	@Override
	public String toString() {
		return visibleName;
	}
}
