/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.game.editor.KeyControllerEditor;
import com.serponix.game.editor.ModelEditor;
import com.serponix.game.editor.MouseControllerEditor;
import com.serponix.gui.WindowInterface;
import java.awt.BorderLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

/**
 * JPanel herního panelu, který vytvoří vybraný model hry, view a controller.
 *
 * @author Daniel Vala
 */
public class GamingArea extends JPanel {

	private GameModel model;

	/**
	 * Vytvoří nový herní panel.
	 *
	 * @param okno         Interface okna pro přístup k ovládání celé hry (např. přístup zpět do menu)
	 * @param parametryHry Parametry hry
	 * @param skoreStitky  Štítky, na které se bude psát skóre všech hráčů.
	 * @param panelZprav   Panel zpráv, kam se budou psát zprávy o nových událostech.
	 */
	public GamingArea(WindowInterface okno, GameParameters parametryHry, JLabel[] skoreStitky, MessagePanel panelZprav) {
		setLayout(new BorderLayout());

		if (parametryHry.getMode() == GameModeEnum.CLASSIC_SNAKE) {
			model = new ModelClassic(okno, parametryHry, this, skoreStitky, panelZprav);
		} else if (parametryHry.getMode() == GameModeEnum.TRON) {
			model = new ModelTron(okno, parametryHry, this, skoreStitky, panelZprav);
		} else if (parametryHry.getMode() == GameModeEnum.RECORD) {
			model = new ModelRecord(okno, parametryHry, this, skoreStitky, panelZprav);
		} else if (parametryHry.getMode() == GameModeEnum.FUN_MOD) {
			model = new ModelFun(okno, parametryHry, this, skoreStitky, panelZprav);
		} else if (parametryHry.getMode() == GameModeEnum.CLIENT) {
			model = new ModelClient(okno, parametryHry, this, skoreStitky, panelZprav);
			addKeyListener(new ControllerHracClient((ModelClient) model));
		}

		if (parametryHry.getMode() == GameModeEnum.EDITOR) {
			ModelEditor modelEditor = new ModelEditor(okno, panelZprav);
			add(modelEditor);
			addKeyListener(new KeyControllerEditor(modelEditor));
			addMouseListener(new MouseControllerEditor(modelEditor));
			addMouseMotionListener(new MouseControllerEditor(modelEditor));
			return;
		}

		if (parametryHry.getMode() != GameModeEnum.CLIENT) {
			addKeyListener(new ControllerServer(model));
			for (int i = 0; i < model.getPocetHadu(); i++) {
				if (model.getHrac(i).getOvladani().isKeyboard()) {
					ControllerHracServer c = new ControllerHracServer(model.getHrac(i));
					addKeyListener(c);
				}
			}
		}
		add(new View(model));
	}
}
