/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.net.Informace;
import java.awt.BorderLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;

/**
 * Panel of messages can display new messages at the top and scroll down earlier.
 *
 * @author Daniel Vala
 */
public class MessagePanel extends JPanel {

	private JTextArea area;
	private String messageToSend;

	public MessagePanel() {
		setLayout(new BorderLayout());
		area = new JTextArea(5, 1);
		area.setEditable(false);
		area.setFocusable(false);
		add(new JScrollPane(area));
	}

	public String getMessageToSend() {
		String message = Informace.INFO + Informace.ODDELOVAC1;
		if (messageToSend != null) {
			message += messageToSend;
			messageToSend = null;
		} else {
			return null;
		}
		return message;
	}

	/**
	 * Display given message.
	 *
	 * @param message New message to display.
	 */
	public void addMessage(final String message) {
		messageToSend = message;
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				area.insert(message + "\n", 0);
				area.setCaretPosition(0);
			}
		});
	}

	public void eraseAllText() {
		SwingUtilities.invokeLater(new Runnable() {

			@Override
			public void run() {
				try {
					area.getDocument().remove(0, area.getDocument().getLength());
				} catch (BadLocationException ex) {
					System.err.println("Chyba mazání v panelu zpráv.");
				}
			}
		});
	}
}
