/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.game.score.Score;
import com.serponix.gui.WindowInterface;
import java.awt.Graphics;
import java.util.Collections;
import javax.swing.JLabel;

/**
 * Dědí z Modelu, reprezentuje mód Tron.
 *
 * @author Daniel Vala
 */
public class ModelTron extends GameModel {

	public ModelTron(WindowInterface okno, GameParameters parametryHry, GamingArea herniPanel, JLabel[] skoreStitky, MessagePanel panelZprav) {
		super(okno, parametryHry, herniPanel, skoreStitky, panelZprav, parametryHry.getSizeOfGamingArea());
		parametryHry.getServer().setModel(this);
		net = parametryHry.getServer();
		hadi = new Snake[getPocetHadu()];
		vytvorListPocatecnichPozic(10);
		Collections.shuffle(listPocatecnichPozic);
		for (int i = 0; i < hadi.length; i++) {
			hadi[i] = new Snake(this, getHrac(i), listPocatecnichPozic.get(i), -1, Direction.DOWN, 1, getVelikostPolicka(), 5, 0, barvy[i], null, false, false);
			getHrac(i).init(this, hadi[i]);
		}
		startHry();
	}

	public void upravSkore(Score skore) {
	}

	@Override
	void paintZdi(Graphics g) {
		getMapa().kresliMapu(g);
	}

	@Override
	public void resetHada(Snake had) {
		had.smrt();
	}

	@Override
	public void newRound() {
		Collections.shuffle(listPocatecnichPozic);
		Snake[] listHadu = getHadi();
		for (int i = 0; i < getPocetHadu(); i++) {
			listHadu[i].setHad(listPocatecnichPozic.get(i), -1, Direction.DOWN);
		}
		pockej(1000);
		ozivVsechnyHady();
	}

	@Override
	public void jidloSezrano(Snake had) {
	}

	@Override
	public void bonusSezran(Snake had) {
	}

	// metoda krok kontroluje jestli had nenarazil do steny, jestli had neji a jestli had nenarazil do druheho hada
	@Override
	public void krok() {
		for (int i = 0; i < getPocetHadu(); i++) {
			getHrac(i).posunSe();
			hadi[i].prodluzHada();
			setSkoreText(i, "Hrac " + getHrac(i).getJmeno() + "   Vyhry: " + hadi[i].score.getPocetVyher() + "  |");
		}

		setChanged();
		notifyObservers();
	}

	@Override
	public void paint(Graphics g) {
		if (!zobrazVeciNaPlose) {
			for (Snake had : hadi) {
				had.draw(g);
			}
		} else {
			zobrazVeciNaPlose(g);
		}
	}

	@Override
	public void addScore(Score skore, int body) {
	}
}
