/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import com.serponix.ai.AI;
import com.serponix.ai.StandardAI;
import java.net.DatagramPacket;

/**
 * Hráč vlastní jednoho hada, ovládání, kterým bude hada ovládat a jméno.
 * Obsahuje metodu pro posun hada.
 *
 * @author Daniel Vala
 */
public class Player {

	private String name;
	private Snake snake;
	private AI ai;
	private DatagramPacket packet;
	private Control control;
	private Direction novySmer;
	// počet povolených pozastavení hry pro hráče, pauznutí a odpauznutí se počítá zvlášť
	private int pocetPause;
	private GameModel model;

	public Player(String name, Control control, DatagramPacket packet) {
		this.name = name;
		this.control = control;
		this.packet = packet;
	}

	public void init(GameModel model, Snake snake) {
		this.model = model;
		this.snake = snake;
		pocetPause = 10;
		if (control == Control.AI_STANDARD) {
			if (model instanceof ModelTron) {
				// TODO create AI for Tron
			} else {
				ai = new StandardAI(model, this);
			}
		}
	}

	public void zapniAI() {
		ai = new StandardAI(model, this);
	}

	public void vypniAI() {
		ai = null;
	}

	public void setSmer(Direction smer) {
		novySmer = smer;
	}

	public void changeSmer(Direction novySmer) {
		if (this.novySmer == null) {
			this.novySmer = novySmer;
		}
	}

	public Direction getNovySmer() {
		return novySmer;
	}

	public void posunSe() {
		if (ai != null) {
			ai.setNewDirection();
		}
		if (novySmer != null) {
			snake.changeSmer(novySmer);
			if (snake.move()) {
				novySmer = null;
			}
		} else {
			snake.move();
		}
	}

	public Control getOvladani() {
		return control;
	}

	public DatagramPacket getPacket() {
		return packet;
	}

	public String getJmeno() {
		return name;
	}

	@Override
	public String toString() {
		return name;
	}

	public Snake getSnake() {
		return snake;
	}

	public AI getAI() {
		return ai;
	}

	public void pause() {
		model.pauza();
		//        if (had.isAlive()) {
		//            if (pocetPause > 0) {
		//                model.pauza();
		//                pocetPause--;
		//            } else if (pocetPause == 0) {
		//                model.addZprava(String.format("%s spamuje hru přestávkami. Bylo mu odebráno právo pozastavit hru.", jmeno));
		//                pocetPause--;
		//            }
		//        }
	}

	public enum Control {

		KEYBOARD1(true), KEYBOARD2(true), KEYBOARD3(true), KEYBOARD4(true), AI_EASY(false), AI_STANDARD(false), AI_HARD(false), CLIENT(false);
		private final boolean keyboard;

		private Control(boolean k) {
			keyboard = k;
		}

		public static int getCisloKlavesnice(Control ovladani) {
			if (ovladani == Control.KEYBOARD1) {
				return 0;
			} else if (ovladani == Control.KEYBOARD2) {
				return 1;
			} else if (ovladani == Control.KEYBOARD3) {
				return 2;
			} else if (ovladani == Control.KEYBOARD4) {
				return 3;
			}
			return -1;
		}

		public boolean isKeyboard() {
			return keyboard;
		}
	}
}
