/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game;

import java.awt.Color;

/**
 * Políčko hry reprezentuje objekt, který může být nakreslen na políčko herní plochy.
 * Objekt má svůj typ a souřadnice. Obsahuje barvu, dodatečné informace, směr a určení, zda je objekt neviditelný.
 * Objekt je určen pro přenos informací o políčku po síti.
 *
 * @author Daniel Vala
 */
public class Policko {

	private int typ;
	private int x;
	private int y;
	private Color barva;
	private int informace;
	private Direction smer;
	private boolean neviditelny;

	public Policko(int typ, int x, int y, Color barva, int informace, Direction smer, boolean neviditelny) {
		this.typ = typ;
		this.x = x;
		this.y = y;
		this.barva = barva;
		this.informace = informace;
		this.smer = smer;
		this.neviditelny = neviditelny;
	}

	public int getTyp() {
		return typ;
	}

	public void setTyp(int typ) {
		this.typ = typ;
	}

	public int getX() {
		return x;
	}

	public void setX(int x) {
		this.x = x;
	}

	public int getY() {
		return y;
	}

	public void setY(int y) {
		this.y = y;
	}

	public Color getBarva() {
		return barva;
	}

	public void setBarva(Color barva) {
		this.barva = barva;
	}

	public int getInformace() {
		return informace;
	}

	public void setInformace(int informace) {
		this.informace = informace;
	}

	public Direction getSmer() {
		return smer;
	}

	public void setSmer(Direction smer) {
		this.smer = smer;
	}

	public boolean getNeviditelnost() {
		return neviditelny;
	}

	public void setNeviditelnost(boolean neviditelnost) {
		this.neviditelny = neviditelnost;
	}
}
