/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.food;

import com.serponix.game.GameModel;
import com.serponix.net.Informace;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Toolkit;

/**
 * Cherry is a bonus food, which should provide special abilities or more score point.
 *
 * @author Daniel Vala
 */
public class Cherry extends Food {

	private static Image textura = Toolkit.getDefaultToolkit().getImage(Panel.class.getResource("/images/food/cherries.gif"));

	public Cherry(GameModel model) {
		super(model);
	}

	public static void paint(Graphics g, int x, int y) {
		x *= 10;
		y *= 10;
		g.drawImage(textura, x, y, 10, 10, null);
	}

	@Override
	public Image getTextura() {
		return textura;
	}

	@Override
	public String getInstrukceProKresleni() {
		return Informace.BONUS + Informace.ODDELOVAC3 + getX() + Informace.ODDELOVAC3 + getY() + Informace.ODDELOVAC2;
	}

	@Override
	public void draw(Graphics g) {
		paint(g, getX(), getY());
	}
}
