/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.objektyNaPlose;

import java.util.ArrayList;
import java.util.List;

/**
 * Smyslem třídy je možnost umístění více věcí na ploše do jednoho políčka.
 * Je to tedy věc na ploše, která v sobě obsahuje více dalších věcí na ploše.
 * Objekt který obsahuje by neměl být tento objekt.
 * Věcí na ploše by mělo být více než 1, jinak objekt nemá smysl.
 *
 * @author Daniel Vala
 */
public class ViceObjektu extends VecNaPolicku {

	private List<VecNaPolicku> veciNaPolicku;

	/**
	 * Vytvoří věc na ploše, který v sobě bude obsahovat 2 klasické věci na ploše.
	 *
	 * @param vecNaPlose1 První věc na ploše.
	 * @param vecNaPlose2 Druhá věc na ploše.
	 */
	public ViceObjektu(VecNaPolicku vecNaPlose1, VecNaPolicku vecNaPlose2) {
		super(vecNaPlose1.getX(), vecNaPlose1.getY());
		veciNaPolicku = new ArrayList<VecNaPolicku>();
		veciNaPolicku.add(vecNaPlose1);
		veciNaPolicku.add(vecNaPlose2);
	}

	public List<VecNaPolicku> getVeciNaPolicku() {
		return veciNaPolicku;
	}

	/**
	 * Přidá do objektu další věc na ploše.
	 *
	 * @param vecNaPlose Nová věc na ploše k přidání.
	 */
	public void addVec(VecNaPolicku vecNaPlose) {
		veciNaPolicku.add(vecNaPlose);
	}

	/**
	 * Odstraní zadanou věc na ploše z tohoto objektu, pokud ji tento objekt obsahuje.
	 * Po odstranění je dobré zkontrolovat metodou getPocetVeci, zda pocet věcí je stále 2 nebo více.
	 * V opačném případě je tento objekt zbytečné dále používat, protože už nemá smysl.
	 *
	 * @param vecNaPlose Věc na ploše k odstranění.
	 * @return True, pokud se věc na ploše odstranila. False, pokud se nic nezměnilo.
	 * @see getPocetVeci()
	 */
	public boolean removeVec(VecNaPolicku vecNaPlose) {
		return veciNaPolicku.remove(vecNaPlose);
	}

	/**
	 * Vrátí počet věcí na ploše, který tento objekt obsahuje.
	 *
	 * @return Počet věcí na ploše, který tento objekt obsahuje.
	 */
	public int getPocetVeci() {
		return veciNaPolicku.size();
	}

	/**
	 * Vrátí věc na ploše na požadovaném indexu.
	 *
	 * @param index Index musí být maximálně o jedno menší, než je počet věcí na ploše v tomto objektu.
	 *              Pokud objekt obsahuje 3 věci na ploše, je možné přistoupit indexem 0, 1 a 2 pro jednotlivé prvky.
	 * @return Věc na ploše na požadovaném indexu.
	 * @see getPocetVeci()
	 */
	public VecNaPolicku getVecNaPlose(int index) {
		return veciNaPolicku.get(index);
	}

	/**
	 * Tímto objektem nelze hýbat. Metoda nic neprovede.
	 *
	 * @param x
	 * @param y
	 */
	@Override
	public void move(int x, int y) {
	}
}
