/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.game.score;

import com.serponix.game.GameModel;
import com.serponix.game.Snake;

/**
 * Reprezentuje skóre hada.
 * Umí se vyresetovat, přidat skóre, zjistit počet výher hada.
 * Pokud je skóre dostatečně velké, had vyhraje.
 * Pokud má had dostatečný počet výher, vyhraje celou hru.
 *
 * @author Daniel Vala
 */
public class Score {

	private static final int VYHER_K_VITEZSTVI = 5;
	private int skore;
	private int pocetVyher;
	private Snake had;
	private GameModel model;

	/**
	 * Vytvoří nové skóre s počáteční hodnotou skore a počtem výher 0.
	 *
	 * @param had   Had, kterému bude skóre patřit.
	 * @param model Model hry.
	 */
	public Score(Snake had, GameModel model) {
		this.model = model;
		this.had = had;
	}

	/**
	 * Resetuje skóre na nulovou hodnotu.
	 */
	public void reset() {
		setSkore(0);
	}

	/**
	 * Zjistí aktuální hodnotu skóre.
	 */
	public int getSkore() {
		return skore;
	}

	/**
	 * Nastaví skóre na zadanou hodnotu.
	 *
	 * @param skore Nová hodnota skóre.
	 */
	private void setSkore(int skore) {
		this.skore = skore;
	}

	/**
	 * Zjistí počet výher.
	 *
	 * @return Počet výher.
	 */
	public int getPocetVyher() {
		return pocetVyher;
	}

	/**
	 * Přidá skóre k dosavadnímu skóre.
	 *
	 * @param skore           Nové přidáné skóre.
	 * @param pocetBoduKVyhre Pokud je zadáno více než 0, zkontroluje, zda počet bodů již překročil pocet bodů k výhře.
	 *                        Pokud ano, had vyhraje jednu hru.
	 */
	public void addSkore(int skore, int pocetBoduKVyhre) {
		setSkore(getSkore() + skore);
		if (pocetBoduKVyhre != 0 && getSkore() >= pocetBoduKVyhre) {
			vyhra();
		}
	}

	public void vyhra() {
		model.getPanelZprav().eraseAllText();
		pocetVyher++;
		model.getPanelZprav().addMessage(String.format("%s vyhral", had));
		model.newRound();
		if (pocetVyher >= VYHER_K_VITEZSTVI) {
			model.pauza();
			model.ukonciHruVitezstvim("Hráč " + had + " dosáhl " + VYHER_K_VITEZSTVI + " výher a vyhrál tak celou hru!!");
			model.ukonciHru();
		}
		reset();
	}
}
