/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui;

import com.serponix.game.GamePanel;
import com.serponix.game.GameParameters;
import com.serponix.gui.lobby.ModelLobbyClient;
import com.serponix.gui.lobby.ModelLobbyServer;
import com.serponix.gui.lobby.ViewLobbyClient;
import com.serponix.gui.lobby.ViewLobbyServer;
import com.serponix.gui.settings.ModelNastaveni;
import com.serponix.gui.settings.ViewNastaveni;
import com.serponix.net.Client;
import java.awt.BorderLayout;
import javax.swing.JPanel;

/**
 * MainPanel can create menupanel, lobbypanel, settingpanel, helppanel, informationpanel and gamepanel.
 * Provides method to switch between them (always create a new instance).
 *
 * @author Daniel Vala
 */
public class MainPanel extends JPanel implements WindowInterface {

	/**
	 * Create <code>MainPanel</code>.
	 * First display main menu.
	 */
	public MainPanel() {
		setLayout(new BorderLayout());
		displayMenu();
	}

	/**
	 * Create and display main menu.
	 */
	@Override
	public final void displayMenu() {
		removeAll();
		Menu menu = new Menu(this);
		add(menu);
		revalidate();
	}

	/**
	 * Create and display lobby for server.
	 */
	@Override
	public void displayLobbyForServer() {
		removeAll();
		ModelLobbyServer modelLobbyServer = new ModelLobbyServer(this);
		ViewLobbyServer viewLobby = new ViewLobbyServer(modelLobbyServer, this);
		add(viewLobby);
		revalidate();
	}

	/**
	 * Create and display lobby for client.
	 *
	 * @param client
	 */
	@Override
	public void displayLobbyForClient(Client client) {
		removeAll();
		ModelLobbyClient modelLobbyClient = new ModelLobbyClient(this, client);
		ViewLobbyClient viewLobbyClient = new ViewLobbyClient(modelLobbyClient, this);
		add(viewLobbyClient);
		revalidate();
	}

	/**
	 * Create and display the game itself.
	 *
	 * @param gameParameters Information with parameters for a new game.
	 */
	@Override
	public void displayGame(GameParameters gameParameters) {
		removeAll();
		GamePanel gamePanel = new GamePanel(this, gameParameters);
		add(gamePanel);
		gamePanel.requestFocus();
		revalidate();
	}

	/**
	 * Zobrazí nastavení hry, které lze upravovat.
	 */
	@Override
	public void zobrazPanelNastaveni() {
		removeAll();
		ModelNastaveni modelNastaveni = new ModelNastaveni();
		ViewNastaveni viewNastaveni = new ViewNastaveni(modelNastaveni, this);
		add(viewNastaveni);
		viewNastaveni.requestFocusInWindow();
		revalidate();
	}

	/**
	 * Zobrazí nápovědu ke hře.
	 */
	@Override
	public void zobrazPanelNapovedy() {
		removeAll();
		ViewHelp viewNapoveda = new ViewHelp(this);
		add(viewNapoveda);
		viewNapoveda.requestFocusInWindow();
		revalidate();
	}

	/**
	 * Zobrazí panel s informacemi o hře.
	 */
	@Override
	public void zobrazPanelOHre() {
		removeAll();
		ViewAbout viewOHre = new ViewAbout(this);
		add(viewOHre);
		viewOHre.requestFocusInWindow();
		revalidate();
	}
}
