/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui;

import com.serponix.game.GameParameters;
import com.serponix.net.Client;

/**
 * Defines method to display individual windows.
 *
 * @author Daniel Vala
 */
public interface WindowInterface {

	void displayMenu();

	void displayLobbyForServer();

	void displayLobbyForClient(Client client);

	void displayGame(GameParameters parametryHry);

	void zobrazPanelNastaveni();

	void zobrazPanelNapovedy();

	void zobrazPanelOHre();
}
