/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JOptionPane;

/**
 * Controller pro ukončení založené hry.
 * Zobrazí uživateli potvrzovací okno, zda ji chce opravdu ukončit.
 *
 * @author Daniel Vala
 */
public class ControllerExit implements ActionListener {

	private ModelLobby model;
	private ViewLobby viewLobby;

	public ControllerExit(ModelLobby model, ViewLobby viewLobby) {
		this.model = model;
		this.viewLobby = viewLobby;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Object[] options = { "Ano", "Ne" };
		int vyber;
		if (viewLobby instanceof ViewLobbyServer) {
			vyber = JOptionPane.showOptionDialog(viewLobby, "Opravdu chcete zrušit založenou hru? \n Všichni připojení hráči budou odpojeni.", "Upozornění", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[1]);
		} else {
			vyber = JOptionPane.showOptionDialog(viewLobby, "Opravdu se chcete odpojit ze hry?", "Upozornění", JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE, null, options, options[1]);
		}
		if (vyber != 0) {
			return;
		}
		model.konec();
	}
}
