/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.game.Mapa;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;

/**
 * Controller pro načtení mapy.
 * Uživateli se zobrazí dialogové okno pro výběr soboru mapy.
 *
 * @author Daniel Vala
 */
public class ControllerNactiMapu implements ActionListener {

	private ModelLobbyServer model;
	private JLabel stitekNazevMapy;

	public ControllerNactiMapu(ModelLobbyServer model, JLabel stitekNazevMapy) {
		this.model = model;
		this.stitekNazevMapy = stitekNazevMapy;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		Mapa mapa = new Mapa();
		JFileChooser fc = new JFileChooser();
		fc.addChoosableFileFilter(new FileNameExtensionFilter("Soubory s příponou *.ser", "ser"));
		fc.setCurrentDirectory(new File(Mapa.getPath()));
		if (fc.showOpenDialog(null) == JFileChooser.APPROVE_OPTION) {
			String zobrazenyNazevMapy = fc.getSelectedFile().getName().substring(0, fc.getSelectedFile().getName().length() - 4);
			try {
				mapa.nactiMapu(zobrazenyNazevMapy, new FileInputStream(fc.getSelectedFile()));
			} catch (FileNotFoundException ex) {
				JOptionPane.showMessageDialog(null, "Zvolený soubor neexistuje.", "Chyba", JOptionPane.ERROR_MESSAGE);
			}
		}
		model.setMapa(mapa);
		stitekNazevMapy.setText(mapa.getNazev());
	}
}
