/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTextField;

/**
 * Controller pro posílání zpráv.
 * Zpráva se zobrazí v chatArea a pošle se všem klientům.
 *
 * @author Daniel Vala
 */
public class ControllerZpravy implements ActionListener {

	private ModelLobby model;
	private JTextField textField;

	public ControllerZpravy(ModelLobby model, JTextField textField) {
		this.model = model;
		this.textField = textField;
	}

	@Override
	public void actionPerformed(ActionEvent e) {
		String zprava;
		// pokud zdroj actionEventu není textField, použije se textField zde uložený (při stisknutí tlačítka odeslat)
		if (e.getSource() instanceof JTextField) {
			zprava = e.getActionCommand();
		} else {
			zprava = textField.getText();
		}
		if (!zprava.equals("")) {
			// server zprávu zobrazí a pošle, klient ji pouze pošle (zobrazí ji až když mu dojde zpět od serveru)
			if (model instanceof ModelLobbyServer) {
				model.zobrazAPosliZpravu(model.getJmenoHrace(0) + ": " + zprava);
			} else {
				model.posliZpravu(model.getJmenoHrace(0) + ": " + zprava);
			}
		}
	}
}
