/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.gui.lobby;

import com.serponix.gui.MainPanel;
import java.util.Observable;
import javax.swing.JLabel;

/**
 * View pro klienta obsahuje komponenty GUI specifické pro klienta.
 *
 * @author Daniel Vala
 */
public class ViewLobbyClient extends ViewLobby {

	public ViewLobbyClient(ModelLobbyClient modelLobby, MainPanel okno) {
		super(modelLobby, okno);

		stitekNadpis.setText("Serponix - připojeno ke hře");

		for (int i = 0; i < comboBoxyVyberHrace.length; i++) {
			comboBoxyVyberHrace[i].addItem(modelLobby.getHrac(i));
			comboBoxyVyberHrace[i].setEnabled(false);
		}
		sliderRychlostHry.setEnabled(false);
		comboBoxModHry.addItem(modelLobby.getGameMode());
		comboBoxModHry.setEnabled(false);
		spinnerSirka.setVisible(false);
		spinnerVyska.setVisible(false);
		spinnerSirka.setEnabled(false);
		spinnerVyska.setEnabled(false);
		panelIP.add(new JLabel("Připojeno k " + modelLobby.getServerIP().getHostAddress()));
		exit.addActionListener(new ControllerExit(modelLobby, this));
		exit.setText("odpojit se");
		modelLobby.addObserver(this);
	}

	@Override
	public void update(Observable o, Object arg) {
		if (arg instanceof LobbyEvent) {
			LobbyEvent evt = (LobbyEvent) arg;
			switch (evt) {
				case ZPRAVA:
					zobrazInformaci(evt.data);
					break;
				case ZPRAVA_A_VYMAZ:
					zobrazInformaci(evt.data);
					textFieldZpravy.setText("");
					textFieldZpravy.requestFocus();
					break;
				case VYMAZ:
					textFieldZpravy.setText("");
					textFieldZpravy.requestFocus();
					break;
				case MOD_HRY:
					comboBoxModHry.removeAllItems();
					comboBoxModHry.addItem(evt.data);
					break;
				case MAPA:
					stitekNazevMapy.setText(evt.data);
					break;
				case RYCHLOST:
					try {
						sliderRychlostHry.setValue(Integer.parseInt(evt.data));
					} catch (NumberFormatException ex) {
						System.err.println("Chyba přetypování");
					}
					break;
				case HRAC:
					comboBoxyVyberHrace[evt.cislo].removeAllItems();
					comboBoxyVyberHrace[evt.cislo].addItem(evt.data);
					break;
			}
		} else {
			throw new IllegalArgumentException(arg.getClass().getName() + " není typu LobbyEvent.");
		}
	}
}
