/**
 * Serponix is an arcade game in focus to multiplayer based on the classic game
 * Snake. Copyright (C) 2010 - 2011 Daniel Vala
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * If you have any question do not hesitate to contact author on e-mail address:
 * danielvala42@gmail.com
 */
package com.serponix.gui.settings;

import com.serponix.settings.GameSettings;
import com.serponix.settings.SnakeAction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;

/**
 * Model obsahuje aktuální nastavení všech kláves a metodu pro nastavení všeho
 * do defaultního stavu.
 *
 * @author Daniel Vala
 */
public class ModelNastaveni extends Observable {

	private List<Map<SnakeAction, Integer>> allKeysTemp;

	public ModelNastaveni() {
		GameSettings gameSettings = GameSettings.getInstance();
		copySettingsToTempList(gameSettings);
	}

	public List<Map<SnakeAction, Integer>> getAllKeys() {
		return allKeysTemp;
	}

	public Map<SnakeAction, Integer> getKeyOfGivenPlayer(int player) {
		return allKeysTemp.get(player);
	}

	/**
	 * Map the given key to the given snakeAction on the given player.
	 *
	 * @param player
	 * @param snakeAction
	 * @param key
	 */
	public void setKey(int player, SnakeAction snakeAction, int key) {
		allKeysTemp.get(player).put(snakeAction, key);
	}

	public void setDefault() {
		GameSettings gameSettings = GameSettings.getInstance();
		gameSettings.setDefault();
		copySettingsToTempList(gameSettings); // refresh temp list from the original
		setChanged();
		notifyObservers();
	}

	private void copySettingsToTempList(GameSettings gameSettings) {
		allKeysTemp = new ArrayList<Map<SnakeAction, Integer>>(GameSettings.NUMBER_OF_HUMAN_PLAYERS);
		for (Map<SnakeAction, Integer> mapa : gameSettings.getAllKeys()) {
			allKeysTemp.add(new EnumMap<SnakeAction, Integer>(mapa));
		}
	}
}
