/**
 *  Serponix is an arcade game in focus to multiplayer based on the classic game Snake.
 *  Copyright (C) 2010 - 2011  Daniel Vala
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License,
 *  or  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.

 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 *  If you have any question do not hesitate to contact author
 *  on e-mail address: danielvala42@gmail.com
 */
package com.serponix.net;

import com.serponix.game.GameModel;
import com.serponix.game.Mapa;
import java.awt.Dimension;
import java.net.DatagramPacket;

/**
 * Server rozšiřuje metody o přijem stavu lobby, nastavení modelu, start hry,
 * přijem dat a poslání dat konkrétnímu klientovi.
 *
 * @author Daniel Vala
 */
public interface Server extends Net {

	void prijemStavuLobby();

	void setModel(GameModel model);

	void odstartujHru(int pocetHracu, Dimension velikostHerniPlochy, Mapa mapa);

	void prijemDat();

	@Override
	void poslatData(String zprava);

	@Override
	void odpojSe();

	void posliDataKlientovi(String zprava, DatagramPacket packet);
}
