/**
 * Serponix is an arcade game in focus to multiplayer based on the classic game
 * Snake. Copyright (C) 2010 - 2011 Daniel Vala
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or any later version.
 *
 * This program is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * If you have any question do not hesitate to contact author on e-mail address:
 * danielvala42@gmail.com
 */
package com.serponix.settings;

import com.serponix.game.GameModeEnum;

/**
 * Default settings for the first start of the game, when configuration file
 * does not exist yet.
 *
 * @author vala
 */
public class DefaultSettingsConsts {

	public static final int DEFAULT_SPEED = 60;
	public static final String DEFAULT_SERVER_IP = "";
	public static final int DEFAULT_NUMBER_OF_ACTIVE_PLAYERS = 2;
	public static final int DEFAULT_PORT = 56429;
	public static final GameModeEnum DEFAULT_GAME_MODE = GameModeEnum.FUN_MOD;
	public static final String[] DEFAULT_NAME_OF_PLAYERS = { System.getProperty("user.name"), "player2", "player3", "player4" };
	public static final int[][] DEFAULT_KEYS = { { 38, 40, 37, 39, 32, 17 }, { 87, 83, 65, 68, 49, 50 }, { 85, 74, 72, 75, 53, 54 }, { 104, 101, 100, 102, 34, 33 } };
}
