/* 
 *  @author -- Lateef Yusuf
 *  @email -- iamlateef@gatech.edu
 *  @date -- Jul 21, 2010 
 */

package com.simplegdatamaps;

import com.simplegdatamaps.R;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;

public class MapActivity extends Activity {
	    
    public static Context getContext()
    { return mContext; }
    
    @Override
    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setRequestedOrientation(1);
	    mContext = this.getApplicationContext();
	    locationConn = new LocationConnection(this);
        initMain();
    }
    
    @Override
    protected void onPause() {
    	super.onPause();
    }
    
    @Override
    protected void onResume() {
        super.onResume();
        locationConn.connect();
    }
    
    public boolean onCreateOptionsMenu(Menu menu) {
    	boolean result = super.onCreateOptionsMenu(menu);
        return result;
    }
    
    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
            return super.onOptionsItemSelected(item);
    }
  
    private void initMain() {
        setContentView(R.layout.main);
        String username = Constants.GOOGLEMAPS_DEFAULT_USER;
        String password = Constants.GOOGLEMAPS_DEFAULT_USER_PASSWD;
        GoogleMapsClient gClient = new GoogleMapsClient(username, password);
        String id = gClient.addMap("aMap", "description");
    	gClient.searchMap(id, 20, 20, 3);
    }
    
    LocationConnection locationConn;
     
    
    private static Context mContext;
   
	
}
