/* 
 *  @author -- Lateef Yusuf
     @email -- iamlateef@gatech.edu
 *  @date -- Jul 21, 2010 
 */
package com.simplegdatamaps;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class URLConnection {

	public enum RequestType {
		GET, POST, PUT, DELETE
	}

	public static String createURLParams(String[] keys, String[] values) {
		StringBuilder br = new StringBuilder();
		for (int i = 0; i < keys.length; i++) {
			try {
				if (i > 0)
					br.append("&");
				br.append(URLEncoder.encode(keys[i], "UTF-8"));
				br.append("=");
				br.append(URLEncoder.encode(values[i], "UTF-8"));
			} catch (Exception e) {
			}
		}
		return br.toString();
	}

	public static String writeToString(InputStream stream) {
		try {
			StringBuilder br = new StringBuilder();
			byte[] b = new byte[100];
			int read = stream.read(b);
			while (read > -1) {
				String c = new String(b, 0, read);
				br.append(c);
				read = stream.read(b);
			}
			stream.close();
			return br.toString();
		} catch (Exception e) {
		}
		return null;
	}

	public static String postRequest(String urlStr, String data) {
		HttpURLConnection connection = null;
		try {
			// Send data
			URL url = new URL(urlStr);

			connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("POST");
			connection.setRequestProperty("Content-Type",
					"application/x-www-form-urlencoded");

			connection.setRequestProperty("Content-Length", ""
					+ Integer.toString(data.getBytes().length));
			connection.setRequestProperty("Content-Language", "en-US");

			connection.setUseCaches(false);
			connection.setDoInput(true);
			connection.setDoOutput(true);

			// Send request
			DataOutputStream wr = new DataOutputStream(connection
					.getOutputStream());
			wr.writeBytes(data);
			wr.flush();
			wr.close();

			// Get Response
			InputStream is = connection.getInputStream();
			BufferedReader rd = new BufferedReader(new InputStreamReader(is));
			String line;
			StringBuffer response = new StringBuffer();
			while ((line = rd.readLine()) != null) {
				response.append(line);
			}
			rd.close();
			return response.toString();

		} catch (Exception e) {
			return null;

		} finally {

			if (connection != null) {
				connection.disconnect();
			}
		}
	}

	public static InputStream getAuthorizedRequest(String urlStr,
			String authToken) {
		try {
			URL url = new URL(urlStr);
			HttpURLConnection connection = (HttpURLConnection) url
					.openConnection();
			connection.setRequestProperty("Authorization", "GoogleLogin auth="
					+ authToken);
			connection.connect();
			InputStream urlStream = url.openStream();
			return urlStream;
		} catch (IOException e) {
		}
		return null;
	}

	public static InputStream postAuthorizedRequest(String urlStr, String data,
			String authToken, RequestType type) {
		HttpURLConnection connection = null;
		try {
			// Send data
			URL url = new URL(urlStr);

			connection = (HttpURLConnection) url.openConnection();
			connection.setRequestMethod("POST");
			switch (type) {
			case PUT:
				connection.setRequestProperty("X-HTTP-Method-Override", "PUT");
				break;
			case DELETE:
				connection.setRequestProperty("X-HTTP-Method-Override",
						"DELETE");
				break;
			default:
				break;
			}
			connection.setRequestProperty("Authorization", "GoogleLogin auth="
					+ authToken);
			connection.setRequestProperty("Content-Type",
					"application/atom+xml");

			int length = data.getBytes().length;
			connection.setRequestProperty("Content-Length", ""
					+ Integer.toString(length));
			connection.setRequestProperty("Content-Language", "en-US");

			connection.setUseCaches(false);
			connection.setDoInput(true);
			connection.setDoOutput(true);

			// Send request
			DataOutputStream wr = new DataOutputStream(connection
					.getOutputStream());
			wr.writeBytes(data);
			wr.flush();
			wr.close();

			// Get Response
			InputStream urlStream = connection.getInputStream();
			return urlStream;

		} catch (Exception e) {
		}
		return null;
	}

}