/* 
 *  @author -- Lateef Yusuf
 *  @email -- iamlateef@gatech.edu
 *  @date -- Jul 21, 2010 
 */
package com.simplegdatamaps;

public class GDataAtomXMLBuilder {

	public static String getAddMapXML(String title, String description) {
		StringBuilder entry = new StringBuilder();
		entry.append("<entry xmlns=\"http://www.w3.org/2005/Atom\">");
		entry.append("<title>");
		entry.append(title);
		entry.append("</title>");
		entry.append("<summary>");
		entry.append(description);
		entry.append("</summary>");
		entry.append("</entry>");
		return entry.toString();
	}

	public static String getAddLocationFeatureXML(String title,
			String name, double latitude, double longitude) {
		return new StringBuilder(
				"<atom:entry xmlns='http://www.opengis.net/kml/2.2'").append(
				" xmlns:atom='http://www.w3.org/2005/Atom'>").append(
				"<atom:title type='text'>").append(name).append(
				"</atom:title>").append(
				"<atom:content type='application/vnd.google-earth.kml+xml'>")
				.append(" <Placemark><name>").append(title).append(
						"</name><description/>")
				.append("<Point> <coordinates>").append(latitude).append(",")
				.append(longitude).append(",0.0</coordinates>").append(
						"</Point></Placemark></atom:content></atom:entry>")
				.toString();
	}
}
