package org.simplextensions.examples.views;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.simplextensions.annotations.Extension;
import org.simplextensions.ui.view.ASWTView;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Extension
public class SimpleSWTView3 extends ASWTView {

	private static final Logger log = LoggerFactory.getLogger(SimpleSWTView3.class);

	public void createContents() {
		log.info("createView");

		Composite clientArea = getViewRegion().getClientArea();
		clientArea.setLayout(new GridLayout());
		Label label = new Label(clientArea, SWT.NORMAL);
		label.setText("Sample SimpleXtensions View3");
		label.setLayoutData(new GridData(SWT.CENTER, SWT.CENTER, true, true));

		clientArea.redraw();
		clientArea.layout();
	}

	public String getName() {
		return "SimpleView3";
	}

	protected Image getImage() {
		InputStream resourceAsStream = getClass().getResourceAsStream("/decision.png");
		Image image = null;
		if (resourceAsStream != null) {
			image = new Image(getViewRegion().getClientArea().getDisplay(), resourceAsStream);
			try {
				resourceAsStream.close();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		return image;
	}

}
