package org.simplextensions.di;

import org.simplextensions.annotations.AnnotationInfo;
import org.simplextensions.di.annotations.Point;
import org.simplextensions.di.annotations.Registry;
import org.simplextensions.di.annotations.ServiceDependency;
import org.simplextensions.registry.IExtensionPoint;
import org.simplextensions.registry.IExtensionRegistry;
import org.simplextensions.registry.IServiceRegistry;
import org.simplextensions.registry.phaselisteners.IDependencyLocator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;

/**
 * 
 * @author Tomasz Krzyżak
 * 
 */
public class EnvironmentDependencyLocator implements IDependencyLocator {

	private IExtensionRegistry extensionRegistry;

	public EnvironmentDependencyLocator(IExtensionRegistry extensionRegistry) {
		init(extensionRegistry);
	}

	public Object getAnnotatedFieldValue(Field field, AnnotationInfo annotationInfo) {
		Object result = null;
		Class<?> fieldType = (Class<?>) field.getType();

		Annotation annotation = annotationInfo.getAnnotation();

		if (annotation instanceof ServiceDependency) {
			IServiceRegistry serviceRegistry = extensionRegistry.getExtensionPoint(IServiceRegistry.class);
			result = serviceRegistry.getService(fieldType);
		} else if (annotation instanceof Registry) {
			return extensionRegistry;
		} else if (annotation instanceof Point) {
			String ep_id = ((Point) annotation).value();
			if ("".equals(ep_id)) {
				result = extensionRegistry.getExtensionPoint((Class<? extends IExtensionPoint>) fieldType);
			} else {
				result = extensionRegistry.getExtensionPoint((Class<? extends IExtensionPoint>) fieldType, ep_id);
			}
		}
		return result;
	}

	@SuppressWarnings("unchecked")
	public Class<? extends Annotation>[] getSupportedAnnotations() {
		return new Class[] { ServiceDependency.class, Registry.class, Point.class };
	}

	public void init(IExtensionRegistry extensionRegistry) {
		this.extensionRegistry = extensionRegistry;
	}
}
