/**
 * 
 */
package org.simplextensions.registry;

import org.simplextensions.annotations.ExtensionStyle;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

/**
 * @author Tomasz Krzyzak, <a
 *         href="mailto:tomasz.krzyzak@gmail.com">tomasz.krzyzak@gmail.com</a>
 * @since 2009-07-30 22:35:47
 * 
 */
public class ExtensionPoint extends ConfigurableElem {

	private Set<Class<?>> defaultExtensionClasses = new HashSet<Class<?>>();

	public ExtensionPoint(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, IExtensionPoint executable, String id) {
		super(extensionRegistry, bundle, executable, id);
	}

	public ExtensionPoint(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String clazz, String id, Class<?> defaultExtensionClasses[],
			ExtensionStyle extensionStyle, String factoryMethod) {
		super(extensionRegistry, bundle, clazz, id, extensionStyle, factoryMethod);
		this.defaultExtensionClasses.addAll(Arrays.asList(defaultExtensionClasses));
	}

	/**
	 * @return the extensionClass
	 */
	public Set<Class<?>> getDefaultExtensionClasses() {
		return Collections.unmodifiableSet(defaultExtensionClasses);
	}

	private IExtensionPoint extensionInstance = null;
	
	public synchronized IExtensionPoint getExecutable() {
		if (extensionInstance == null)
			extensionInstance = (IExtensionPoint) super.getExecutable();
		return extensionInstance;
	}

}
