package org.simplextensions.registry;

import javassist.bytecode.ClassFile;
import javassist.bytecode.annotation.Annotation;
import org.simplextensions.scanner.IClassScanner;

public class ScanPhaseListenerAdapter implements IClassScanner {

	private final ISimpleXtensionsClassScanner extensionScanPhaseListener;
	private final IExtensionRegistry registry;
	private final SimpleXtensionsBundle bundle;
	private final String annotationClassName;

	public ScanPhaseListenerAdapter(String annotationClassName, IExtensionRegistry registry, SimpleXtensionsBundle bundle,
			ISimpleXtensionsClassScanner extensionScanPhaseListener) {
		this.annotationClassName = annotationClassName;
		this.registry = registry;
		this.bundle = bundle;
		this.extensionScanPhaseListener = extensionScanPhaseListener;
	}

	public void scanClass(ClassFile classFile, Annotation a) {
		if (a.getTypeName().equals(this.annotationClassName))
			extensionScanPhaseListener.scanClass(registry, bundle, classFile.getName(), a);
	}

}