package org.simplextensions.registry.phaselisteners;

import javassist.bytecode.annotation.Annotation;
import org.simplextensions.registry.*;
import org.simplextensions.scanner.ClassScannerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/**
 * 
 * @author Mirek Szajowski m.szajowski@gmail.com
 * 
 */
public class DependencyLocatorScanPhaseListener implements ISimpleXtensionsClassScanner {

	private static final Logger log = LoggerFactory.getLogger(DependencyLocatorScanPhaseListener.class);

	public void scanClass(IExtensionRegistry extensionRegistry, SimpleXtensionsBundle bundle, String className, Annotation a) {
		log.trace("scanning service locator class: " + className);

		Class<?>[] annotations = ClassScannerHelper.getClassesValue(a, "value");
		for (Class<?> annotation : annotations) {
			String simpleClassName = className.substring(className.lastIndexOf('.') + 1);
			Extension extension = new Extension(extensionRegistry, bundle, className, simpleClassName+"_"+annotation.getSimpleName());

			extension.setPropertyValue(IDependencyLocator.ANNOTATION, new PropertyValue(annotation));

			extensionRegistry.addExtension(extension, IDependencyLocator.EP_ID);
		}

	}
}
