package org.simplextensions.registry;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.Simplextensions;

import static junit.framework.TestCase.assertNotNull;
import static org.mockito.Mockito.*;

@RunWith(MockitoJUnitRunner.class)
public class ExtensionRegistryTest {

	@Before
	public void setUp() {
		System.out.println("------------------- setup -------------------");
	}

	@Test
	public void testCreate() {
		IExtensionRegistry default1 = Simplextensions.createNewRegistry();
		assertNotNull(default1);
	}

	@Test
	public void testScan() {
		IExtensionRegistry default1 = Simplextensions.createNewRegistry();
		IServiceRegistry serviceRegistry = default1.getExtensionPoint(IServiceRegistry.class);

		assertNotNull(serviceRegistry);
	}

	@Test
	public void testDontCreateExecutable() {
		ExtensionRegistry extensionRegistry = new ExtensionRegistry();
		extensionRegistry = spy(extensionRegistry);
		Simplextensions.findBundles(extensionRegistry);

		verify(extensionRegistry, times(0)).createExecutable(any(ConfigurableElem.class));
	}

}
