package org.simplextensions.scanner;

import javassist.bytecode.ClassFile;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.runners.MockitoJUnitRunner;
import org.simplextensions.registry.exceptions.ExtensionsConfigurationException;
import org.simplextensions.scanner.impl.ClassLoaderCSB;

import java.util.*;

import static org.junit.Assert.assertFalse;
import static org.junit.Assert.assertNotNull;

@RunWith(MockitoJUnitRunner.class)
public class ClassLoaderCSBTest {

	private ClassLoaderCSB classLoaderCSB;
	private Iterator<ClassFile> classFileIterator;

	@Before
	public void setUp() {
		classLoaderCSB = new ClassLoaderCSB("TestBundle", new HashMap<String, Map<Integer, List<IClassScanner>>>(), new HashSet<String>(
				Arrays.asList("org.simplextensions.scanner.ClassLoaderCSBTest")));
		classFileIterator = classLoaderCSB.classFileIterator();
	}

	@Test
	public void test() {
		assertNotNull(classFileIterator.next());
	}

	@Test(expected = NoSuchElementException.class)
	public void testException() {

		assertNotNull(classFileIterator.next());
		assertFalse(classFileIterator.hasNext());

		classFileIterator.next();
	}

	@Test(expected = ExtensionsConfigurationException.class)
	public void testConfigurationException() {
		classLoaderCSB = new ClassLoaderCSB("TestBundle", new HashMap<String, Map<Integer, List<IClassScanner>>>(), new HashSet<String>(
				Arrays.asList("org.simplextensions.scanner.ClassLoaderCSBTest", "dupa")));
		classFileIterator = classLoaderCSB.classFileIterator();

		assertNotNull(classFileIterator.next());
		assertNotNull(classFileIterator.hasNext());
	}

}
